/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.SignatureOnly;

import de.safe_ev.transparenzsoftware.Utils;
import de.safe_ev.transparenzsoftware.verification.ContainedPublicKeyParser;
import de.safe_ev.transparenzsoftware.verification.DecodingException;
import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.VerificationType;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLSignature;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLValidationException;
import de.safe_ev.transparenzsoftware.verification.format.sml.SMLVerificationParserBase;
import de.safe_ev.transparenzsoftware.verification.format.sml.SignatureOnly.SMLReader;
import de.safe_ev.transparenzsoftware.verification.format.sml.SignatureOnly.SMLVerifiedData;
import de.safe_ev.transparenzsoftware.verification.format.sml.SignatureOnly.embedded.SignedMeterValue;
import de.safe_ev.transparenzsoftware.verification.result.Error;
import de.safe_ev.transparenzsoftware.verification.result.IntrinsicVerified;
import de.safe_ev.transparenzsoftware.verification.result.VerificationResult;
import de.safe_ev.transparenzsoftware.verification.xml.VerifiedData;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureOnlyVerificationParser
extends SMLVerificationParserBase
implements ContainedPublicKeyParser {
    private static final Logger LOGGER = LogManager.getLogger(SignatureOnlyVerificationParser.class);
    private final SMLReader smlReader = new SMLReader();

    @Override
    public VerificationType getVerificationType() {
        return VerificationType.EDL_40_SIG;
    }

    @Override
    public VerificationResult parseAndVerify(String data, byte[] publicKey, IntrinsicVerified intrinsicVerified) {
        try {
            SignedMeterValue signedMeterValue = this.smlReader.readFromString(Utils.unescapeXML(data));
            signedMeterValue.validate();
            SMLSignature smlSignature = this.smlReader.parseSMLSigXml(signedMeterValue);
            if (smlSignature.getUnit() != 30) {
                throw new SMLValidationException("Invalid unit present in sml data", "error.sml.invalid.unit");
            }
            SMLVerifiedData verifiedData = new SMLVerifiedData(smlSignature, VerificationType.EDL_40_SIG, EncodingType.PLAIN, Utils.toFormattedHex(publicKey));
            if (intrinsicVerified.ok() || this.verifier.verify(publicKey, smlSignature)) {
                return new VerificationResult((VerifiedData)verifiedData, intrinsicVerified);
            }
            return new VerificationResult((VerifiedData)verifiedData, Error.withVerificationFailed());
        }
        catch (ValidationException e) {
            return new VerificationResult(Error.withValidationException(e));
        }
    }

    @Override
    public boolean canParseData(String data) {
        try {
            SignedMeterValue signedMeterValue = this.smlReader.readFromString(Utils.unescapeXML(data));
            signedMeterValue.validate();
        }
        catch (ValidationException e) {
            LOGGER.info("Data not matching for " + String.valueOf((Object)VerificationType.EDL_40_SIG));
            return false;
        }
        LOGGER.info("Match for " + String.valueOf((Object)VerificationType.EDL_40_SIG) + " detected");
        return true;
    }

    @Override
    public String parsePublicKey(String data) {
        try {
            SignedMeterValue signedMeterValue = this.smlReader.readFromString(Utils.unescapeXML(data));
            return signedMeterValue.getPublicKey() != null ? signedMeterValue.getPublicKey().getCleanedValue() : null;
        }
        catch (ValidationException e) {
            return null;
        }
    }

    @Override
    public String createFormattedKey(String data) {
        String parsedKey;
        String formattedKey = parsedKey = this.parsePublicKey(data);
        List<EncodingType> encodingTypes = EncodingType.guessType(parsedKey, false);
        if (encodingTypes.size() > 0) {
            try {
                formattedKey = Utils.toFormattedHex(encodingTypes.get(0).decode(parsedKey), 4);
            }
            catch (DecodingException e) {
                LOGGER.warn("Could not decode parsed key", (Throwable)e);
            }
        }
        return formattedKey;
    }
}

