/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.format.sml.SignatureOnly.embedded;

import de.safe_ev.transparenzsoftware.verification.DecodingException;
import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import jakarta.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class EncodingValue {
    public abstract String getEncoding();

    public abstract String getValue();

    public String getCleanedValue() {
        String value = this.getValue();
        value = value.replaceAll(" ", "").replaceAll("\n", "").replaceAll("\t", "");
        return value;
    }

    public byte[] getValueEncoded() throws ValidationException {
        EncodingType encoding = EncodingType.fromCode(this.getEncoding());
        if (encoding == null || this.getValue() == null) {
            throw new ValidationException("Could not find a decoder", "error.unknown.encoding");
        }
        String value = this.getCleanedValue();
        byte[] payloadBytes = new byte[]{};
        try {
            payloadBytes = EncodingType.decode(encoding, value);
        }
        catch (DecodingException e) {
            throw new ValidationException("Could not decode a data", "error.unknown.encoding");
        }
        return payloadBytes;
    }
}

