/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.input;

import de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes.embedded.Billing;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes.embedded.BillingAdapterException;
import de.safe_ev.transparenzsoftware.verification.format.sml.EDLMennekes.embedded.BillingToValuesAdapter;
import de.safe_ev.transparenzsoftware.verification.input.InvalidInputException;
import de.safe_ev.transparenzsoftware.verification.xml.Values;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;

public class InputReader {
    private final Unmarshaller unmarshaller;
    private final Marshaller marshaller;

    public InputReader() {
        try {
            JAXBContext jc = JAXBContext.newInstance(Values.class, Billing.class);
            this.unmarshaller = jc.createUnmarshaller();
            this.marshaller = jc.createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Values readFile(File file) throws InvalidInputException {
        try {
            Object unmarshalled = this.unmarshaller.unmarshal(file);
            Values value = unmarshalled instanceof Billing ? BillingToValuesAdapter.convertBilling(this.marshaller, (Billing)unmarshalled) : (Values)unmarshalled;
            String fileContent = new String(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
            value.setRawContent(fileContent);
            return value;
        }
        catch (JAXBException | IOException e) {
            throw new InvalidInputException("Cannot read input file", "error.input.string.noxml", e);
        }
        catch (BillingAdapterException e) {
            throw new InvalidInputException(e.getMessage(), e.getLocalizedMessageKey(), e);
        }
    }

    public Values readString(String data) throws InvalidInputException {
        try {
            StringReader stringReader = new StringReader(data);
            Values value = (Values)this.unmarshaller.unmarshal(stringReader);
            value.setRawContent(data);
            return value;
        }
        catch (Exception e) {
            throw new InvalidInputException("Cannot read input string", "error.input.string.noxml", e);
        }
    }
}

