/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.result;

import de.safe_ev.transparenzsoftware.gui.views.helper.DetailsList;
import de.safe_ev.transparenzsoftware.verification.RegulationLawException;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.format.ocmf.OCMFVerifiedData;
import de.safe_ev.transparenzsoftware.verification.result.Error;
import de.safe_ev.transparenzsoftware.verification.result.IntrinsicVerified;
import de.safe_ev.transparenzsoftware.verification.xml.Meter;
import de.safe_ev.transparenzsoftware.verification.xml.VerifiedData;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VerificationResult {
    private List<Meter> meters;
    private boolean verified;
    private IntrinsicVerified intrinsicVerified;
    private DetailsList additionalVerificationData;
    private VerifiedData verifiedData;
    private final List<Error> errorMessages = new ArrayList<Error>();
    private boolean transactionResult = false;
    private BigInteger transactionId;

    private VerificationResult() {
        this.meters = new ArrayList<Meter>();
    }

    public VerificationResult(VerifiedData verifiedData, boolean transactionResult, IntrinsicVerified intrinsicVerified) {
        this();
        this.meters = verifiedData.getMeters();
        this.additionalVerificationData = verifiedData.getAdditionalData();
        this.verifiedData = verifiedData;
        this.verified = true;
        this.transactionResult = transactionResult;
        this.intrinsicVerified = intrinsicVerified;
    }

    public VerificationResult(VerifiedData verifiedData, IntrinsicVerified intrinsicVerified) {
        this(verifiedData, false, intrinsicVerified);
    }

    private VerificationResult(VerifiedData verifiedData, List<Error> errors) {
        this();
        if (verifiedData != null) {
            this.meters = verifiedData.getMeters();
            this.additionalVerificationData = verifiedData.getAdditionalData();
        } else {
            this.additionalVerificationData = new DetailsList();
        }
        this.verified = false;
        this.errorMessages.addAll(errors);
        this.verifiedData = verifiedData;
    }

    public VerificationResult(VerifiedData verifiedData, Error error) {
        this(verifiedData, Collections.singletonList(error));
    }

    public VerificationResult(Error error) {
        this(null, error);
    }

    public void addError(Error error) {
        this.errorMessages.add(error);
        this.verified = false;
    }

    public DetailsList getAdditionalVerificationData() {
        return this.additionalVerificationData;
    }

    public VerifiedData getVerifiedData() {
        return this.verifiedData;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public List<Error> getErrorMessages() {
        return this.errorMessages;
    }

    public boolean containsErrorOfType(Error.Type type) {
        for (Error errorMessage : this.errorMessages) {
            if (errorMessage == null || !errorMessage.getType().equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    public List<Meter> getMeters() {
        return this.meters;
    }

    public static VerificationResult mergeVerificationData(VerificationResult start, VerificationResult stop, BigInteger transactionId) throws ValidationException {
        VerificationResult verificationResult = new VerificationResult();
        verificationResult.verified = start.isVerified() && stop.isVerified();
        DetailsList additionalDataMerged = new DetailsList();
        for (String key : start.getAdditionalVerificationData().keySet()) {
            Object o1 = start.getAdditionalVerificationData().get(key);
            Object o2 = stop.getAdditionalVerificationData().get(key);
            if (o1 != null && o1.equals(o2)) {
                additionalDataMerged.put(key, o1);
                continue;
            }
            additionalDataMerged.put(String.format("%s (start)", key), o1);
            additionalDataMerged.put(String.format("%s (stop)", key), o2);
        }
        verificationResult.additionalVerificationData = additionalDataMerged;
        for (Error error : start.getErrorMessages()) {
            verificationResult.addError(error);
        }
        for (Error error : stop.getErrorMessages()) {
            verificationResult.addError(error);
        }
        if (!(start.getVerifiedData() instanceof OCMFVerifiedData)) {
            for (Meter meter : start.getMeters()) {
                verificationResult.meters.add(new Meter(meter.getValue(), meter.getTimestamp(), Meter.Type.START, meter.getTimeSyncType(), meter.getScaling(), meter.isCompensated()));
            }
            for (Meter meter : stop.getMeters()) {
                verificationResult.meters.add(new Meter(meter.getValue(), meter.getTimestamp(), Meter.Type.STOP, meter.getTimeSyncType(), meter.getScaling(), meter.isCompensated()));
            }
        } else {
            verificationResult.meters.addAll(start.getMeters());
            verificationResult.meters.addAll(stop.getMeters());
        }
        verificationResult.transactionResult = true;
        verificationResult.transactionId = transactionId;
        if (verificationResult.isVerified() && start.getVerifiedData() != null && stop.getVerifiedData() != null) {
            try {
                start.getVerifiedData().lawConform(stop.getVerifiedData());
            }
            catch (RegulationLawException e) {
                Error lawViolation = new Error(Error.Type.VERIFICATION, e.getMessage(), e.getLocalizedMessageKey());
                verificationResult.addError(lawViolation);
            }
        }
        return verificationResult;
    }

    public boolean isTransactionResult() {
        return this.transactionResult;
    }

    public BigInteger getTransactionId() {
        return this.transactionId;
    }
}

