/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.xml;

import de.safe_ev.transparenzsoftware.verification.EncodingType;
import de.safe_ev.transparenzsoftware.verification.VerificationType;
import de.safe_ev.transparenzsoftware.verification.input.InvalidInputException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlValue;

@XmlRootElement(name="encodedData")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EncodedData {
    @XmlAttribute
    private String format;
    @XmlAttribute
    private String encoding;
    @XmlValue
    private String value;

    public EncodedData() {
    }

    public EncodedData(VerificationType format, EncodingType encoding, String value) {
        this.format = format.name();
        this.encoding = encoding.getCode();
        this.value = value;
    }

    public String getFormat() {
        return this.format;
    }

    public VerificationType getFormatAsVerificationType() {
        if (this.format == null) {
            return null;
        }
        try {
            return VerificationType.valueOf(this.format.trim().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public EncodingType getEncodingType() {
        return EncodingType.fromCode(this.encoding);
    }

    public String getValue() {
        return this.value != null ? this.value.trim() : null;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void validate(boolean enforceTypeChecking) throws InvalidInputException {
        if (enforceTypeChecking) {
            try {
                VerificationType.valueOf(this.format);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidInputException("Invalid encoding supplied", "error.values.signeddata.invalid.encoding", e);
            }
            if (EncodingType.fromCode(this.encoding) == null) {
                throw new InvalidInputException("Invalid encoding type supplied", "error.values.signeddata.invalid.format");
            }
        }
        if (this.value == null || this.value.trim().isEmpty()) {
            throw new InvalidInputException("Empty value provided", "error.values.signeddata.empty.value");
        }
    }
}

