/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.xml;

import de.safe_ev.transparenzsoftware.Utils;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeAdapter
extends XmlAdapter<String, LocalDateTime> {
    private static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");

    @Override
    public LocalDateTime unmarshal(String s2) throws Exception {
        return LocalDateTime.parse(Utils.clearString(s2), FORMAT);
    }

    @Override
    public String marshal(LocalDateTime localDateTime) throws Exception {
        return LocalDateTimeAdapter.formattedDateTime(localDateTime);
    }

    public static String formattedDateTime(LocalDateTime localDateTime) {
        return LocalDateTimeAdapter.formattedDateTime(localDateTime, FORMAT);
    }

    public static String formattedDateTime(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter) {
        return localDateTime != null ? localDateTime.format(dateTimeFormatter) : "";
    }
}

