/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.xml;

import de.safe_ev.transparenzsoftware.i18n.Translator;
import de.safe_ev.transparenzsoftware.verification.ValidationException;
import de.safe_ev.transparenzsoftware.verification.xml.OffsetDateTimeAdapter;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="result")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Meter {
    private String descriptiveMessageText;
    private final double value;
    @XmlTransient
    private final OffsetDateTime timestamp;
    @XmlTransient
    private final Type type;
    @XmlTransient
    private TimeSyncType timeSyncType;
    @XmlTransient
    private int scaling = -1;
    @XmlTransient
    private boolean lawRelevant = true;
    @XmlTransient
    private boolean compensated;

    private Meter() {
        this.value = 0.0;
        this.timestamp = null;
        this.type = null;
    }

    public Meter(double value, OffsetDateTime timestamp, int scale, boolean compensated) {
        this(value, timestamp, null, TimeSyncType.INFORMATIVE, scale, compensated);
    }

    public Meter(double value, OffsetDateTime timestamp, int scale) {
        this(value, timestamp, null, TimeSyncType.INFORMATIVE, scale, false);
    }

    public Meter(double value, OffsetDateTime timestamp, Type type, TimeSyncType timeSyncType, int scaling, boolean compensated) {
        this.value = value;
        this.timestamp = timestamp;
        this.type = type;
        this.timeSyncType = timeSyncType;
        if (scaling > 3) {
            scaling = 3;
        }
        if (scaling < -2) {
            scaling = -2;
        }
        this.scaling = scaling;
        this.compensated = compensated;
    }

    public void setDescriptiveMessageText(String text) {
        this.descriptiveMessageText = text;
    }

    public String getDescriptiveMessageText() {
        return this.descriptiveMessageText;
    }

    public double getValue() {
        return this.value;
    }

    @XmlJavaTypeAdapter(value=OffsetDateTimeAdapter.class)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getAdditonalText() {
        ArrayList<String> additionalData = new ArrayList<String>();
        if (this.timeSyncType != null && !this.timeSyncType.equals((Object)TimeSyncType.SYNCHRONIZED)) {
            additionalData.add(Translator.get(this.timeSyncType.message));
        }
        return String.join((CharSequence)", ", additionalData);
    }

    public static double getDifference(List<Meter> values) {
        if (values == null || values.size() < 2) {
            return 0.0;
        }
        double[] minmax = Meter.getMinMax(values);
        return minmax[1] - minmax[0];
    }

    private static double[] getMinMax(List<Meter> values) {
        double minimum = Double.MAX_VALUE;
        double max = Double.NEGATIVE_INFINITY;
        boolean startMarkerFound = false;
        boolean stopMarkerFound = false;
        for (Meter meter : values) {
            if (meter.type != null) {
                if (meter.type.equals((Object)Type.START)) {
                    startMarkerFound = true;
                    minimum = meter.getValue();
                }
                if (meter.type.equals((Object)Type.STOP)) {
                    stopMarkerFound = true;
                    max = meter.getValue();
                }
            }
            if (!startMarkerFound) {
                minimum = Math.min(minimum, meter.getValue());
            }
            if (stopMarkerFound) continue;
            max = Math.max(max, meter.getValue());
        }
        return new double[]{minimum, max};
    }

    public static Duration getTimeDiff(List<Meter> values) {
        if (values == null || values.size() < 2) {
            return Duration.ofMillis(0L);
        }
        boolean startMarkerFound = false;
        boolean stopMarkerFound = false;
        OffsetDateTime minimumTime = null;
        OffsetDateTime maximumTime = null;
        for (Meter meter : values) {
            if (meter.getTimestamp() == null) continue;
            if (meter.type != null && meter.type.equals((Object)Type.START)) {
                startMarkerFound = true;
                minimumTime = meter.getTimestamp();
            }
            if (meter.type != null && meter.type.equals((Object)Type.STOP)) {
                stopMarkerFound = true;
                maximumTime = meter.getTimestamp();
            }
            if (!startMarkerFound && (minimumTime == null || meter.getTimestamp().isBefore(minimumTime))) {
                minimumTime = meter.getTimestamp();
            }
            if (stopMarkerFound || maximumTime != null && !meter.getTimestamp().isAfter(maximumTime)) continue;
            maximumTime = meter.getTimestamp();
        }
        if (minimumTime == null || maximumTime == null) {
            return Duration.ofMillis(0L);
        }
        return Duration.between(minimumTime, maximumTime);
    }

    public static TimeSyncType getTimeSyncType(List<Meter> meters) {
        TimeSyncType timeSyncType = null;
        for (Meter meter : meters) {
            if (!meter.isLawRelevant()) continue;
            TimeSyncType mt = meter.getTimeSyncType();
            if (timeSyncType == null || mt == TimeSyncType.INFORMATIVE) {
                timeSyncType = mt;
                continue;
            }
            if (timeSyncType == TimeSyncType.INFORMATIVE && (mt == TimeSyncType.REALTIME || mt == TimeSyncType.SYNCHRONIZED)) {
                timeSyncType = TimeSyncType.REALTIME;
                continue;
            }
            if (timeSyncType != TimeSyncType.SYNCHRONIZED || mt != TimeSyncType.REALTIME) continue;
            timeSyncType = TimeSyncType.REALTIME;
        }
        if (timeSyncType == null) {
            return TimeSyncType.INFORMATIVE;
        }
        return timeSyncType;
    }

    public static List<Meter> filterLawRelevant(List<Meter> meters) {
        ArrayList<Meter> result = new ArrayList<Meter>();
        for (Meter m4 : meters) {
            if (!m4.isLawRelevant()) continue;
            result.add(m4);
        }
        return result;
    }

    public static void validateListStartStop(List<Meter> startList, List<Meter> stopList) throws ValidationException {
        double[] minmax2;
        if (startList == null || startList.isEmpty()) {
            throw new ValidationException("No start values", "error.values.no.start.meter.values");
        }
        if (stopList == null || stopList.isEmpty()) {
            throw new ValidationException("No stop values", "app.view.no.stop.meter.values");
        }
        double[] minmax1 = Meter.getMinMax(startList);
        if (minmax1[1] > (minmax2 = Meter.getMinMax(stopList))[0]) {
            throw new ValidationException("Stop value is less than start value", "app.view.stop.less.than.start");
        }
    }

    @XmlTransient
    public TimeSyncType getTimeSyncType() {
        return this.timeSyncType;
    }

    @XmlTransient
    public Type getType() {
        return this.type;
    }

    public String getScalingFormat() {
        int format = 3 - this.scaling;
        return "%." + format + "f";
    }

    public int getScaling() {
        return this.scaling;
    }

    public boolean isLawRelevant() {
        return this.lawRelevant;
    }

    public void setLawRelevant(boolean lawRelevant) {
        this.lawRelevant = lawRelevant;
    }

    public boolean isCompensated() {
        return this.compensated;
    }

    public void setCompensated(boolean compensated) {
        this.compensated = compensated;
    }

    public static enum Type {
        START("app.verify.start"),
        STOP("app.verify.end"),
        UPDATE("app.verify.update");

        public final String message;

        private Type(String message) {
            this.message = message;
        }
    }

    public static enum TimeSyncType {
        INFORMATIVE("app.informative"),
        REALTIME("app.informative"),
        SYNCHRONIZED("app.synchronized");

        private final String message;

        private TimeSyncType(String s2) {
            this.message = s2;
        }
    }
}

