/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.xml;

import de.safe_ev.transparenzsoftware.verification.input.InvalidInputException;
import de.safe_ev.transparenzsoftware.verification.xml.EncodedData;
import de.safe_ev.transparenzsoftware.verification.xml.PublicKey;
import de.safe_ev.transparenzsoftware.verification.xml.SignedData;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;

@XmlRootElement(name="value")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Value {
    public static final String CONTEXT_BEGIN = "Transaction.Begin";
    public static final String CONTEXT_END = "Transaction.End";
    @XmlAttribute
    private String context;
    @XmlAttribute
    private BigInteger transactionId;
    private EncodedData encodedData;
    private PublicKey publicKey;
    private SignedData signedData;

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public SignedData getSignedData() {
        return this.signedData;
    }

    public void setSignedData(SignedData signedData) {
        this.signedData = signedData;
    }

    public void validate(boolean enforceTypeChecking) throws InvalidInputException {
        if (this.publicKey != null) {
            this.publicKey.validate(enforceTypeChecking);
        }
        if (this.signedData == null) {
            if (this.encodedData == null) {
                throw new InvalidInputException("No signed or encoded data supplied", "error.values.no.publickey");
            }
            this.encodedData.validate(enforceTypeChecking);
        } else {
            if (this.encodedData != null) {
                throw new InvalidInputException("Both signed and encoded data supplied", "error.values.both.encoded.and.signed");
            }
            this.signedData.validate(enforceTypeChecking);
        }
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public BigInteger getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(BigInteger transactionId) {
        this.transactionId = transactionId;
    }

    public EncodedData getEncodedData() {
        return this.encodedData;
    }

    public void setEncodedData(EncodedData encodedData) {
        this.encodedData = encodedData;
    }

    public boolean hasSignedData() {
        return this.signedData != null;
    }
}

