/*
 * Decompiled with CFR 0.152.
 */
package de.safe_ev.transparenzsoftware.verification.xml;

import de.safe_ev.transparenzsoftware.verification.input.InvalidInputException;
import de.safe_ev.transparenzsoftware.verification.xml.Value;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.beans.Transient;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="values")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Values {
    @XmlElement(name="value")
    private List<Value> values = null;
    private String rawContent;

    public List<Value> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<Value>();
        }
        return this.values;
    }

    public void setValues(List<Value> values) {
        this.values = values;
    }

    public void validate(boolean enforceTypeChecking) throws InvalidInputException {
        if (this.values == null || this.values.isEmpty()) {
            throw new InvalidInputException("No values supplied", "error.values.no.values");
        }
        for (Value value : this.values) {
            value.validate(enforceTypeChecking);
        }
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    @Transient
    public Value findSecondTransaction(int indexOrigin, BigInteger transactionId) {
        for (int i = 0; i < this.values.size(); ++i) {
            Value value = this.values.get(i);
            if (i == indexOrigin || !transactionId.equals(value.getTransactionId())) continue;
            return value;
        }
        return null;
    }
}

