/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.ScriptingEnvironment;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.bridge.svg12.ContentSelectionChangedEvent;
import org.apache.batik.bridge.svg12.SVG12BridgeUpdateHandler;
import org.apache.batik.dom.svg12.BindableElement;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

public class BindableElementBridge
extends AbstractGraphicsNodeBridge
implements SVG12BridgeUpdateHandler {
    public String getNamespaceURI() {
        return "*";
    }

    public String getLocalName() {
        return "*";
    }

    public Bridge getInstance() {
        return new BindableElementBridge();
    }

    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e) {
        if (!SVGUtilities.matchUserAgent(e, ctx.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode gn = this.buildCompositeGraphicsNode(ctx, e, null);
        return gn;
    }

    public CompositeGraphicsNode buildCompositeGraphicsNode(BridgeContext ctx, Element e, CompositeGraphicsNode gn) {
        ScriptingEnvironment se;
        BindableElement be = (BindableElement)e;
        Element shadowTree = be.getXblShadowTree();
        UpdateManager um = ctx.getUpdateManager();
        ScriptingEnvironment scriptingEnvironment = se = um == null ? null : um.getScriptingEnvironment();
        if (se != null && shadowTree != null) {
            se.addScriptingListeners(shadowTree);
        }
        if (gn == null) {
            gn = new CompositeGraphicsNode();
            this.associateSVGContext(ctx, e, gn);
        } else {
            int s2 = gn.size();
            for (int i = 0; i < s2; ++i) {
                gn.remove(0);
            }
        }
        GVTBuilder builder = ctx.getGVTBuilder();
        if (shadowTree != null) {
            GraphicsNode shadowNode = builder.build(ctx, shadowTree);
            if (shadowNode != null) {
                gn.add(shadowNode);
            }
        } else {
            for (Node m4 = e.getFirstChild(); m4 != null; m4 = m4.getNextSibling()) {
                GraphicsNode n;
                if (m4.getNodeType() != 1 || (n = builder.build(ctx, (Element)m4)) == null) continue;
                gn.add(n);
            }
        }
        return gn;
    }

    public void dispose() {
        BindableElement be = (BindableElement)this.e;
        if (be != null && be.getCSSFirstChild() != null) {
            this.disposeTree(be.getCSSFirstChild());
        }
        super.dispose();
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        this.initializeDynamicSupport(ctx, e, node);
    }

    public void handleDOMNodeInsertedEvent(MutationEvent evt) {
        BindableElement be = (BindableElement)this.e;
        Element shadowTree = be.getXblShadowTree();
        if (shadowTree == null && evt.getTarget() instanceof Element) {
            this.handleElementAdded((CompositeGraphicsNode)this.node, this.e, (Element)((Object)evt.getTarget()));
        }
    }

    public void handleBindingEvent(Element bindableElement, Element shadowTree) {
        CompositeGraphicsNode gn = this.node.getParent();
        gn.remove(this.node);
        this.disposeTree(this.e);
        this.handleElementAdded(gn, this.e.getParentNode(), this.e);
    }

    public void handleContentSelectionChangedEvent(ContentSelectionChangedEvent csce) {
    }

    protected void handleElementAdded(CompositeGraphicsNode gn, Node parent, Element childElt) {
        GVTBuilder builder = this.ctx.getGVTBuilder();
        GraphicsNode childNode = builder.build(this.ctx, childElt);
        if (childNode == null) {
            return;
        }
        int idx = -1;
        for (Node ps = childElt.getPreviousSibling(); ps != null; ps = ps.getPreviousSibling()) {
            GraphicsNode psgn;
            if (ps.getNodeType() != 1) continue;
            Element pse = (Element)ps;
            for (psgn = this.ctx.getGraphicsNode(pse); psgn != null && psgn.getParent() != gn; psgn = psgn.getParent()) {
            }
            if (psgn != null && (idx = gn.indexOf(psgn)) != -1) break;
        }
        gn.add(++idx, childNode);
    }
}

