/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.swing;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DoubleDocument
extends PlainDocument {
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        String curVal = this.getText(0, this.getLength());
        boolean hasDot = curVal.indexOf(46) != -1;
        char[] buffer = str.toCharArray();
        char[] digit = new char[buffer.length];
        int j = 0;
        if (offs == 0 && buffer != null && buffer.length > 0 && buffer[0] == '-') {
            digit[j++] = buffer[0];
        }
        for (int i = 0; i < buffer.length; ++i) {
            if (Character.isDigit(buffer[i])) {
                digit[j++] = buffer[i];
            }
            if (hasDot || buffer[i] != '.') continue;
            digit[j++] = 46;
            hasDot = true;
        }
        String added = new String(digit, 0, j);
        try {
            StringBuffer val = new StringBuffer(curVal);
            val.insert(offs, added);
            String valStr = val.toString();
            if (valStr.equals(".") || valStr.equals("-") || valStr.equals("-.")) {
                super.insertString(offs, added, a);
            } else {
                Double.valueOf(valStr);
                super.insertString(offs, added, a);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public void setValue(double d) {
        try {
            this.remove(0, this.getLength());
            this.insertString(0, String.valueOf(d), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public double getValue() {
        try {
            String t2 = this.getText(0, this.getLength());
            if (t2 != null && t2.length() > 0) {
                return Double.parseDouble(t2);
            }
            return 0.0;
        }
        catch (BadLocationException e) {
            throw new Error(e.getMessage());
        }
    }
}

