/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.BatikHistogramNormalizationFilter8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class BatikHistogramNormalizationElementBridge
extends AbstractSVGFilterPrimitiveElementBridge
implements BatikExtConstants {
    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "histogramNormalization";
    }

    public Bridge getInstance() {
        return new BatikHistogramNormalizationElementBridge();
    }

    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        Filter in = BatikHistogramNormalizationElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx);
        if (in == null) {
            return null;
        }
        Filter sourceGraphics = (Filter)filterMap.get("SourceGraphic");
        Rectangle2D defaultRegion = in == sourceGraphics ? filterRegion : in.getBounds2D();
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx);
        float trim = 1.0f;
        String s2 = filterElement.getAttributeNS(null, "trim");
        if (s2.length() != 0) {
            try {
                trim = SVGUtilities.convertSVGNumber(s2);
            }
            catch (NumberFormatException nfEx) {
                throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{"trim", s2});
            }
        }
        if (trim < 0.0f) {
            trim = 0.0f;
        } else if (trim > 100.0f) {
            trim = 100.0f;
        }
        Filter filter = in;
        filter = new BatikHistogramNormalizationFilter8Bit(filter, trim / 100.0f);
        filter = new PadRable8Bit(filter, primitiveRegion, PadMode.ZERO_PAD);
        BatikHistogramNormalizationElementBridge.updateFilterMap(filterElement, filter, filterMap);
        BatikHistogramNormalizationElementBridge.handleColorInterpolationFilters(filter, filterElement);
        return filter;
    }

    protected static int convertSides(Element filterElement, String attrName, int defaultValue, BridgeContext ctx) {
        String s2 = filterElement.getAttributeNS(null, attrName);
        if (s2.length() == 0) {
            return defaultValue;
        }
        int ret = 0;
        try {
            ret = SVGUtilities.convertSVGInteger(s2);
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, filterElement, nfEx, "attribute.malformed", new Object[]{attrName, s2});
        }
        if (ret < 3) {
            throw new BridgeException(ctx, filterElement, "attribute.malformed", new Object[]{attrName, s2});
        }
        return ret;
    }
}

