/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.FixedColRowGroupBuilder;
import org.apache.fop.fo.flow.table.RowGroupBuilder;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableRow;

class VariableColRowGroupBuilder
extends RowGroupBuilder {
    private List events = new LinkedList();

    VariableColRowGroupBuilder(Table t2) {
        super(t2);
    }

    void addTableCell(final TableCell cell) {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.addTableCell(cell);
            }
        });
    }

    void startTableRow(final TableRow tableRow) {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.startTableRow(tableRow);
            }
        });
    }

    void endTableRow() {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.endTableRow();
            }
        });
    }

    void endRow(final TableBody part) {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.endRow(part);
            }
        });
    }

    void startTablePart(final TableBody part) {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.startTablePart(part);
            }
        });
    }

    void endTablePart() throws ValidationException {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) throws ValidationException {
                rowGroupBuilder.endTablePart();
            }
        });
    }

    void endTable() throws ValidationException {
        FixedColRowGroupBuilder delegate = new FixedColRowGroupBuilder(this.table);
        Iterator eventIter = this.events.iterator();
        while (eventIter.hasNext()) {
            ((Event)eventIter.next()).play(delegate);
        }
        ((RowGroupBuilder)delegate).endTable();
    }

    private static interface Event {
        public void play(RowGroupBuilder var1) throws ValidationException;
    }
}

