/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.datatypes.LengthBase;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FOPropertyMapping;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.PropertyParser;
import org.apache.fop.fo.properties.CorrespondingPropertyMaker;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.ShorthandParser;

public class PropertyMaker
implements Cloneable {
    private static Log log = LogFactory.getLog(PropertyMaker.class);
    protected int propId;
    private boolean inherited = true;
    private Map enums = null;
    private Map keywords = null;
    protected String defaultValue = null;
    protected boolean contextDep = false;
    protected boolean setByShorthand = false;
    private int percentBase = -1;
    private PropertyMaker[] shorthands = null;
    private ShorthandParser datatypeParser;
    protected Property defaultProperty;
    protected CorrespondingPropertyMaker corresponding;

    public int getPropId() {
        return this.propId;
    }

    public PropertyMaker(int propId) {
        this.propId = propId;
    }

    public void useGeneric(PropertyMaker generic2) {
        this.contextDep = generic2.contextDep;
        this.inherited = generic2.inherited;
        this.defaultValue = generic2.defaultValue;
        this.percentBase = generic2.percentBase;
        if (generic2.shorthands != null) {
            this.shorthands = new PropertyMaker[generic2.shorthands.length];
            System.arraycopy(generic2.shorthands, 0, this.shorthands, 0, this.shorthands.length);
        }
        if (generic2.enums != null) {
            this.enums = new HashMap(generic2.enums);
        }
        if (generic2.keywords != null) {
            this.keywords = new HashMap(generic2.keywords);
        }
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public void addKeyword(String keyword, String value) {
        if (this.keywords == null) {
            this.keywords = new HashMap();
        }
        this.keywords.put(keyword, value);
    }

    public void addEnum(String constant, Property value) {
        if (this.enums == null) {
            this.enums = new HashMap();
        }
        this.enums.put(constant, value);
    }

    public void addSubpropMaker(PropertyMaker subproperty) {
        throw new RuntimeException("Unable to add subproperties " + this.getClass());
    }

    public PropertyMaker getSubpropMaker(int subpropertyId) {
        throw new RuntimeException("Unable to add subproperties");
    }

    public void addShorthand(PropertyMaker shorthand) {
        if (this.shorthands == null) {
            this.shorthands = new PropertyMaker[3];
        }
        for (int i = 0; i < this.shorthands.length; ++i) {
            if (this.shorthands[i] != null) continue;
            this.shorthands[i] = shorthand;
            break;
        }
    }

    public void setDatatypeParser(ShorthandParser parser) {
        this.datatypeParser = parser;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefault(String defaultValue, boolean contextDep) {
        this.defaultValue = defaultValue;
        this.contextDep = contextDep;
    }

    public void setPercentBase(int percentBase) {
        this.percentBase = percentBase;
    }

    public void setByShorthand(boolean setByShorthand) {
        this.setByShorthand = setByShorthand;
    }

    public void setCorresponding(CorrespondingPropertyMaker corresponding) {
        this.corresponding = corresponding;
    }

    public Property makeNewProperty() {
        return null;
    }

    public Property findProperty(PropertyList propertyList, boolean tryInherit) throws PropertyException {
        PropertyList parentPropertyList;
        Property p = null;
        if (log.isTraceEnabled()) {
            log.trace("PropertyMaker.findProperty: " + FOPropertyMapping.getPropertyName(this.propId) + ", " + propertyList.getFObj().getName());
        }
        if (this.corresponding != null && this.corresponding.isCorrespondingForced(propertyList)) {
            p = this.corresponding.compute(propertyList);
        } else {
            p = propertyList.getExplicit(this.propId);
            if (p == null) {
                p = this.getShorthand(propertyList);
            }
            if (p == null) {
                p = this.compute(propertyList);
            }
        }
        if (p == null && tryInherit && (parentPropertyList = propertyList.getParentPropertyList()) != null && this.isInherited()) {
            p = parentPropertyList.get(this.propId, true, false);
        }
        return p;
    }

    public Property get(int subpropertyId, PropertyList propertyList, boolean tryInherit, boolean tryDefault) throws PropertyException {
        Property p = this.findProperty(propertyList, tryInherit);
        if (p == null && tryDefault) {
            p = this.make(propertyList);
        }
        return p;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public PercentBase getPercentBase(PropertyList pl) throws PropertyException {
        if (this.percentBase == -1) {
            return null;
        }
        return new LengthBase(pl, this.percentBase);
    }

    public Property getSubprop(Property p, int subpropertyId) {
        CompoundDatatype val = (CompoundDatatype)p.getObject();
        return val.getComponent(subpropertyId);
    }

    protected Property setSubprop(Property baseProperty, int subpropertyId, Property subproperty) {
        CompoundDatatype val = (CompoundDatatype)baseProperty.getObject();
        val.setComponent(subpropertyId, subproperty, false);
        return baseProperty;
    }

    public Property make(PropertyList propertyList) throws PropertyException {
        if (this.defaultProperty != null) {
            if (log.isTraceEnabled()) {
                log.trace("PropertyMaker.make: reusing defaultProperty, " + FOPropertyMapping.getPropertyName(this.propId));
            }
            return this.defaultProperty;
        }
        if (log.isTraceEnabled()) {
            log.trace("PropertyMaker.make: making default property value, " + FOPropertyMapping.getPropertyName(this.propId) + ", " + propertyList.getFObj().getName());
        }
        Property p = this.make(propertyList, this.defaultValue, propertyList.getParentFObj());
        if (!this.contextDep) {
            this.defaultProperty = p;
        }
        return p;
    }

    public Property make(PropertyList propertyList, String value, FObj fo) throws PropertyException {
        try {
            Property newProp = null;
            String pvalue = value;
            if ("inherit".equals(value)) {
                Property parentExplicit;
                newProp = propertyList.getFromParent(this.propId & 0x1FF);
                if ((this.propId & 0xFFFFFE00) != 0) {
                    newProp = this.getSubprop(newProp, this.propId & 0xFFFFFE00);
                }
                if (!this.isInherited() && log.isWarnEnabled() && (parentExplicit = propertyList.getParentPropertyList().getExplicit(this.getPropId())) == null) {
                    log.warn(FOPropertyMapping.getPropertyName(this.getPropId()) + "=\"inherit\" on " + propertyList.getFObj().getName() + ", but no explicit value found on the parent FO.");
                }
            } else {
                pvalue = this.checkValueKeywords(pvalue.trim());
                newProp = this.checkEnumValues(pvalue);
            }
            if (newProp == null) {
                newProp = PropertyParser.parse(pvalue, new PropertyInfo(this, propertyList));
            }
            if (newProp != null) {
                newProp = this.convertProperty(newProp, propertyList, fo);
            }
            if (newProp == null) {
                throw new PropertyException("No conversion defined " + pvalue);
            }
            return newProp;
        }
        catch (PropertyException propEx) {
            propEx.setLocator(fo.getLocator());
            propEx.setPropertyName(this.getName());
            throw propEx;
        }
    }

    public Property make(Property baseProperty, int subpropertyId, PropertyList propertyList, String value, FObj fo) throws PropertyException {
        return baseProperty;
    }

    public Property convertShorthandProperty(PropertyList propertyList, Property prop, FObj fo) throws PropertyException {
        String pvalue;
        String sval;
        Property pret = this.convertProperty(prop, propertyList, fo);
        if (pret == null && (sval = prop.getNCname()) != null && (pret = this.checkEnumValues(sval)) == null && !(pvalue = this.checkValueKeywords(sval)).equals(sval)) {
            Property p = PropertyParser.parse(pvalue, new PropertyInfo(this, propertyList));
            pret = this.convertProperty(p, propertyList, fo);
        }
        if (pret != null) {
            // empty if block
        }
        return pret;
    }

    protected Property checkEnumValues(String value) {
        if (this.enums != null) {
            Property p = (Property)this.enums.get(value);
            return p;
        }
        return null;
    }

    protected String checkValueKeywords(String keyword) {
        String value;
        if (this.keywords != null && (value = (String)this.keywords.get(keyword)) != null) {
            return value;
        }
        return keyword;
    }

    protected Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
        return null;
    }

    protected Property convertPropertyDatatype(Property p, PropertyList propertyList, FObj fo) throws PropertyException {
        return null;
    }

    protected Property compute(PropertyList propertyList) throws PropertyException {
        if (this.corresponding != null) {
            return this.corresponding.compute(propertyList);
        }
        return null;
    }

    public Property getShorthand(PropertyList propertyList) throws PropertyException {
        if (this.shorthands == null) {
            return null;
        }
        int n = this.shorthands.length;
        for (int i = 0; i < n && this.shorthands[i] != null; ++i) {
            ShorthandParser parser;
            Property p;
            PropertyMaker shorthand = this.shorthands[i];
            Property prop = propertyList.getExplicit(shorthand.propId);
            if (prop == null || (p = (parser = shorthand.datatypeParser).getValueForProperty(this.getPropId(), prop, this, propertyList)) == null) continue;
            return p;
        }
        return null;
    }

    public String getName() {
        return FOPropertyMapping.getPropertyName(this.propId);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exc) {
            return null;
        }
    }
}

