/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.traits.MinOptMax;

public class MinOptMaxUtil {
    public static void restrict(MinOptMax mom, LengthRangeProperty lr, PercentBaseContext context) {
        if (lr.getEnum() != 9) {
            int opt;
            int max;
            int min2;
            if (lr.getMinimum(context).getEnum() != 9 && (min2 = lr.getMinimum(context).getLength().getValue(context)) > mom.min) {
                mom.min = min2;
                MinOptMaxUtil.fixAfterMinChanged(mom);
            }
            if (lr.getMaximum(context).getEnum() != 9 && (max = lr.getMaximum(context).getLength().getValue(context)) < mom.max) {
                mom.max = max;
                if (mom.max < mom.opt) {
                    mom.min = mom.opt = mom.max;
                }
            }
            if (lr.getOptimum(context).getEnum() != 9 && (opt = lr.getOptimum(context).getLength().getValue(context)) > mom.min) {
                mom.opt = opt;
                if (mom.opt > mom.max) {
                    mom.max = mom.opt;
                }
            }
        }
    }

    public static void extendMinimum(MinOptMax mom, int len) {
        if (mom.min < len) {
            mom.min = len;
            mom.opt = Math.max(mom.min, mom.opt);
            mom.max = Math.max(mom.opt, mom.max);
        }
    }

    public static void fixAfterMinChanged(MinOptMax mom) {
        if (mom.min > mom.opt) {
            mom.opt = mom.min;
            if (mom.opt > mom.max) {
                mom.max = mom.opt;
            }
        }
    }

    public static MinOptMax toMinOptMax(LengthRangeProperty prop, PercentBaseContext context) {
        MinOptMax mom = new MinOptMax(prop.getMinimum(context).isAuto() ? 0 : prop.getMinimum(context).getLength().getValue(context), prop.getOptimum(context).isAuto() ? 0 : prop.getOptimum(context).getLength().getValue(context), prop.getMaximum(context).isAuto() ? Integer.MAX_VALUE : prop.getMaximum(context).getLength().getValue(context));
        return mom;
    }
}

