/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.FOText;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.text.linebreak.LineBreakStatus;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;

public class TextLayoutManager
extends LeafNodeLayoutManager {
    private static Log log = LogFactory.getLog(TextLayoutManager.class);
    private ArrayList vecAreaInfo;
    private static final String BREAK_CHARS = "-/";
    private static final MinOptMax ZERO_MINOPTMAX = new MinOptMax(0);
    private FOText foText;
    private char[] textArray;
    private MinOptMax[] letterAdjustArray;
    private static final char NEWLINE = '\n';
    private Font font = null;
    private short iAreaStart = 0;
    private short iNextStart = 0;
    private MinOptMax ipdTotal;
    private int spaceCharIPD;
    private MinOptMax wordSpaceIPD;
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private SpaceVal ws;
    private SpaceVal halfWS;
    private SpaceVal halfLS;
    private int iNbSpacesPending;
    private boolean bChanged = false;
    private int iReturnedIndex = 0;
    private short iThisStart = 0;
    private short iTempStart = 0;
    private LinkedList changeList = null;
    private AlignmentContext alignmentContext = null;
    private int lineStartBAP = 0;
    private int lineEndBAP = 0;
    private boolean keepTogether;
    static final int SOFT_HYPHEN_PENALTY = 1;

    public TextLayoutManager(FOText node) {
        this.foText = node;
        this.textArray = new char[node.endIndex - node.startIndex];
        System.arraycopy(node.ca, node.startIndex, this.textArray, 0, node.endIndex - node.startIndex);
        this.letterAdjustArray = new MinOptMax[this.textArray.length + 1];
        this.vecAreaInfo = new ArrayList();
    }

    public void initialize() {
        FontInfo fi = this.foText.getFOEventHandler().getFontInfo();
        FontTriplet[] fontkeys = this.foText.getCommonFont().getFontState(fi);
        this.font = fi.getFontInstance(fontkeys[0], this.foText.getCommonFont().fontSize.getValue(this));
        this.spaceCharIPD = this.font.getCharWidth(' ');
        this.hyphIPD = this.foText.getCommonHyphenation().getHyphIPD(this.font);
        SpaceVal ls = SpaceVal.makeLetterSpacing(this.foText.getLetterSpacing());
        this.halfLS = new SpaceVal(MinOptMax.multiply(ls.getSpace(), 0.5), ls.isConditional(), ls.isForcing(), ls.getPrecedence());
        this.ws = SpaceVal.makeWordSpacing(this.foText.getWordSpacing(), ls, this.font);
        this.halfWS = new SpaceVal(MinOptMax.multiply(this.ws.getSpace(), 0.5), this.ws.isConditional(), this.ws.isForcing(), this.ws.getPrecedence());
        this.letterSpaceIPD = ls.getSpace();
        this.wordSpaceIPD = MinOptMax.add(new MinOptMax(this.spaceCharIPD), this.ws.getSpace());
        this.keepTogether = this.foText.getKeepTogether().getWithinLine().getEnum() == 7;
    }

    private boolean getHyphenIPD(HyphContext hc, MinOptMax hyphIPD) {
        boolean bCanHyphenate = true;
        int iStopIndex = this.iNextStart + hc.getNextHyphPoint();
        if (this.textArray.length < iStopIndex) {
            iStopIndex = this.textArray.length;
            bCanHyphenate = false;
        }
        hc.updateOffset(iStopIndex - this.iNextStart);
        while (this.iNextStart < iStopIndex) {
            char c = this.textArray[this.iNextStart];
            hyphIPD.opt += this.font.getCharWidth(c);
            this.iNextStart = (short)(this.iNextStart + 1);
        }
        return bCanHyphenate;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        AreaInfo ai = null;
        int iWScount = 0;
        int iLScount = 0;
        int firstAreaInfoIndex = -1;
        int lastAreaInfoIndex = 0;
        MinOptMax realWidth = new MinOptMax(0);
        while (posIter.hasNext()) {
            LeafPosition tbpNext = (LeafPosition)posIter.next();
            if (tbpNext == null || tbpNext.getLeafPos() == -1) continue;
            ai = (AreaInfo)this.vecAreaInfo.get(tbpNext.getLeafPos());
            if (firstAreaInfoIndex == -1) {
                firstAreaInfoIndex = tbpNext.getLeafPos();
            }
            iWScount += ai.iWScount;
            iLScount += ai.iLScount;
            realWidth.add(ai.ipdArea);
            lastAreaInfoIndex = tbpNext.getLeafPos();
        }
        if (ai == null) {
            return;
        }
        int textLength = ai.iBreakIndex - ai.iStartIndex;
        if (ai.iLScount == textLength && !ai.bHyphenated && context.isLastArea()) {
            realWidth.add(MinOptMax.multiply(this.letterSpaceIPD, -1.0));
            --iLScount;
        }
        for (int i = ai.iStartIndex; i < ai.iBreakIndex; ++i) {
            MinOptMax ladj = this.letterAdjustArray[i + 1];
            if (ladj == null || !ladj.isElastic()) continue;
            ++iLScount;
        }
        if (context.isLastArea() && ai.bHyphenated) {
            realWidth.add(new MinOptMax(this.hyphIPD));
        }
        int iDifference = 0;
        int iTotalAdjust = 0;
        int iWordSpaceDim = this.wordSpaceIPD.opt;
        int iLetterSpaceDim = this.letterSpaceIPD.opt;
        double dIPDAdjust = context.getIPDAdjust();
        double dSpaceAdjust = context.getSpaceAdjust();
        iDifference = dIPDAdjust > 0.0 ? (int)((double)(realWidth.max - realWidth.opt) * dIPDAdjust) : (int)((double)(realWidth.opt - realWidth.min) * dIPDAdjust);
        iLetterSpaceDim = dIPDAdjust > 0.0 ? (iLetterSpaceDim += (int)((double)(this.letterSpaceIPD.max - this.letterSpaceIPD.opt) * dIPDAdjust)) : (iLetterSpaceDim += (int)((double)(this.letterSpaceIPD.opt - this.letterSpaceIPD.min) * dIPDAdjust));
        iTotalAdjust += (iLetterSpaceDim - this.letterSpaceIPD.opt) * iLScount;
        if (iWScount > 0) {
            iWordSpaceDim += (iDifference - iTotalAdjust) / iWScount;
        }
        if ((iTotalAdjust += (iWordSpaceDim - this.wordSpaceIPD.opt) * iWScount) != iDifference) {
            log.trace("TextLM.addAreas: error in word / letter space adjustment = " + (iTotalAdjust - iDifference));
            iTotalAdjust = iDifference;
        }
        TextArea t2 = this.createTextArea(realWidth, iTotalAdjust, context, this.wordSpaceIPD.opt - this.spaceCharIPD, firstAreaInfoIndex, lastAreaInfoIndex, context.isLastArea());
        t2.setTextLetterSpaceAdjust(iLetterSpaceDim);
        t2.setTextWordSpaceAdjust(iWordSpaceDim - this.spaceCharIPD - 2 * t2.getTextLetterSpaceAdjust());
        if (context.getIPDAdjust() != 0.0) {
            t2.setSpaceDifference(this.wordSpaceIPD.opt - this.spaceCharIPD - 2 * t2.getTextLetterSpaceAdjust());
        }
        this.parentLM.addChildArea(t2);
    }

    protected TextArea createTextArea(MinOptMax width, int adjust, LayoutContext context, int spaceDiff, int firstIndex, int lastIndex, boolean isLastArea) {
        TextArea textArea = context.getIPDAdjust() == 0.0 ? new TextArea() : new TextArea(width.max - width.opt, width.opt - width.min, adjust);
        textArea.setIPD(width.opt + adjust);
        textArea.setBPD(this.font.getAscender() - this.font.getDescender());
        textArea.setBaselineOffset(this.font.getAscender());
        if (textArea.getBPD() == this.alignmentContext.getHeight()) {
            textArea.setOffset(0);
        } else {
            textArea.setOffset(this.alignmentContext.getOffset());
        }
        int wordStartIndex = -1;
        int len = 0;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            AreaInfo areaInfo = (AreaInfo)this.vecAreaInfo.get(i);
            if (areaInfo.isSpace) {
                for (int j = areaInfo.iStartIndex; j < areaInfo.iBreakIndex; ++j) {
                    char spaceChar = this.textArray[j];
                    if (CharUtilities.isZeroWidthSpace(spaceChar)) continue;
                    textArea.addSpace(spaceChar, 0, CharUtilities.isAdjustableSpace(spaceChar));
                }
                continue;
            }
            if (wordStartIndex == -1) {
                wordStartIndex = i;
                len = 0;
            }
            len += areaInfo.iBreakIndex - areaInfo.iStartIndex;
            if (i != lastIndex && !((AreaInfo)this.vecAreaInfo.get(i + 1)).isSpace) continue;
            if (isLastArea && i == lastIndex && areaInfo.bHyphenated) {
                ++len;
            }
            StringBuffer wordChars = new StringBuffer(len);
            int[] letterAdjust = new int[len];
            int letter = 0;
            for (int j = wordStartIndex; j <= i; ++j) {
                AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(j);
                int lsCount = ai.iLScount;
                wordChars.append(this.textArray, (int)ai.iStartIndex, ai.iBreakIndex - ai.iStartIndex);
                for (int k = 0; k < ai.iBreakIndex - ai.iStartIndex; ++k) {
                    MinOptMax adj = this.letterAdjustArray[ai.iStartIndex + k];
                    if (letter > 0) {
                        int n = letterAdjust[letter] = adj != null ? adj.opt : 0;
                    }
                    if (lsCount > 0) {
                        int n = letter;
                        letterAdjust[n] = letterAdjust[n] + textArea.getTextLetterSpaceAdjust();
                        --lsCount;
                    }
                    ++letter;
                }
            }
            if (isLastArea && i == lastIndex && areaInfo.bHyphenated) {
                wordChars.append(this.foText.getCommonHyphenation().getHyphChar(this.font));
            }
            textArea.addWord(wordChars.toString(), 0, letterAdjust);
            wordStartIndex = -1;
        }
        TraitSetter.addFontTraits(textArea, this.font);
        textArea.addTrait(Trait.COLOR, this.foText.getColor());
        TraitSetter.addTextDecoration(textArea, this.foText.getTextDecoration());
        return textArea;
    }

    private void addToLetterAdjust(int index, int width) {
        if (this.letterAdjustArray[index] == null) {
            this.letterAdjustArray[index] = new MinOptMax(width);
        } else {
            this.letterAdjustArray[index].add(width);
        }
    }

    private void addToLetterAdjust(int index, MinOptMax width) {
        if (this.letterAdjustArray[index] == null) {
            this.letterAdjustArray[index] = new MinOptMax(width);
        } else {
            this.letterAdjustArray[index].add(width);
        }
    }

    private static boolean isSpace(char ch) {
        return ch == ' ' || CharUtilities.isNonBreakableSpace(ch) || CharUtilities.isFixedWidthSpace(ch);
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        this.lineStartBAP = context.getLineStartBorderAndPaddingWidth();
        this.lineEndBAP = context.getLineEndBorderAndPaddingWidth();
        this.alignmentContext = context.getAlignmentContext();
        LinkedList<InlineKnuthSequence> returnList = new LinkedList<InlineKnuthSequence>();
        InlineKnuthSequence sequence = new InlineKnuthSequence();
        AreaInfo ai = null;
        AreaInfo prevAi = null;
        returnList.add(sequence);
        LineBreakStatus lbs = new LineBreakStatus();
        this.iThisStart = this.iNextStart;
        boolean inWord = false;
        boolean inWhitespace = false;
        char ch = '\u0000';
        while (this.iNextStart < this.textArray.length) {
            ch = this.textArray[this.iNextStart];
            boolean breakOpportunity = false;
            int breakAction = this.keepTogether ? 4 : (int)lbs.nextChar(ch);
            switch (breakAction) {
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    breakOpportunity = true;
                    break;
                }
                default: {
                    log.error("Unexpected breakAction: " + breakAction);
                }
            }
            if (inWord) {
                if (breakOpportunity || TextLayoutManager.isSpace(ch) || ch == '\n') {
                    int kern;
                    int lastIndex;
                    for (lastIndex = this.iNextStart; lastIndex > 0 && this.textArray[lastIndex - 1] == '\u00ad'; --lastIndex) {
                    }
                    int wordLength = lastIndex - this.iThisStart;
                    boolean kerning = this.font.hasKerning();
                    MinOptMax wordIPD = new MinOptMax(0);
                    for (int i = this.iThisStart; i < lastIndex; ++i) {
                        char previous;
                        char c = this.textArray[i];
                        int charWidth = this.font.getCharWidth(c);
                        wordIPD.add(charWidth);
                        if (!kerning) continue;
                        int kern2 = 0;
                        if (i > this.iThisStart) {
                            previous = this.textArray[i - 1];
                            kern2 = this.font.getKernValue(previous, c) * this.font.getFontSize() / 1000;
                        } else if (prevAi != null && !prevAi.isSpace && prevAi.iBreakIndex > 0) {
                            previous = this.textArray[prevAi.iBreakIndex - 1];
                            kern2 = this.font.getKernValue(previous, c) * this.font.getFontSize() / 1000;
                        }
                        if (kern2 == 0) continue;
                        this.addToLetterAdjust(i, kern2);
                        wordIPD.add(kern2);
                    }
                    if (kerning && breakOpportunity && !TextLayoutManager.isSpace(ch) && lastIndex > 0 && this.textArray[lastIndex] == '\u00ad' && (kern = this.font.getKernValue(this.textArray[lastIndex - 1], ch) * this.font.getFontSize() / 1000) != 0) {
                        this.addToLetterAdjust(lastIndex, kern);
                    }
                    int iLetterSpaces = wordLength - 1;
                    if (breakOpportunity && !TextLayoutManager.isSpace(ch)) {
                        ++iLetterSpaces;
                    }
                    wordIPD.add(MinOptMax.multiply(this.letterSpaceIPD, iLetterSpaces));
                    ai = new AreaInfo(this.iThisStart, (short)lastIndex, 0, (short)iLetterSpaces, wordIPD, this.textArray[lastIndex] == '\u00ad', false, breakOpportunity);
                    this.vecAreaInfo.add(ai);
                    prevAi = ai;
                    this.iTempStart = this.iNextStart;
                    sequence.addAll(this.createElementsForAWordFragment(alignment, ai, this.vecAreaInfo.size() - 1, this.letterSpaceIPD));
                    ai = null;
                    this.iThisStart = this.iNextStart;
                }
            } else if (inWhitespace) {
                if (ch != ' ' || breakOpportunity) {
                    ai = new AreaInfo(this.iThisStart, this.iNextStart, (short)(this.iNextStart - this.iThisStart), 0, MinOptMax.multiply(this.wordSpaceIPD, this.iNextStart - this.iThisStart), false, true, breakOpportunity);
                    this.vecAreaInfo.add(ai);
                    prevAi = ai;
                    sequence.addAll(this.createElementsForASpace(alignment, ai, this.vecAreaInfo.size() - 1));
                    ai = null;
                    this.iThisStart = this.iNextStart;
                }
            } else {
                if (ai != null) {
                    this.vecAreaInfo.add(ai);
                    prevAi = ai;
                    ai.breakOppAfter = ch == ' ' || breakOpportunity;
                    sequence.addAll(this.createElementsForASpace(alignment, ai, this.vecAreaInfo.size() - 1));
                    ai = null;
                }
                if (breakAction == 5) {
                    if (this.lineEndBAP != 0) {
                        sequence.add(new KnuthGlue(this.lineEndBAP, 0, 0, new LeafPosition(this, -1), true));
                    }
                    ((KnuthSequence)sequence).endSequence();
                    sequence = new InlineKnuthSequence();
                    returnList.add(sequence);
                }
            }
            if (ch == ' ' && this.foText.getWhitespaceTreatment() == 108 || ch == '\u00a0') {
                ai = new AreaInfo(this.iNextStart, (short)(this.iNextStart + 1), 1, 0, this.wordSpaceIPD, false, true, breakOpportunity);
                this.iThisStart = (short)(this.iNextStart + 1);
            } else if (CharUtilities.isFixedWidthSpace(ch) || CharUtilities.isZeroWidthSpace(ch)) {
                MinOptMax ipd = new MinOptMax(this.font.getCharWidth(ch));
                ai = new AreaInfo(this.iNextStart, (short)(this.iNextStart + 1), 0, 0, ipd, false, true, breakOpportunity);
                this.iThisStart = (short)(this.iNextStart + 1);
            } else if (ch == '\n') {
                this.iThisStart = (short)(this.iNextStart + 1);
            }
            inWord = !TextLayoutManager.isSpace(ch) && ch != '\n';
            inWhitespace = ch == ' ' && this.foText.getWhitespaceTreatment() != 108;
            this.iNextStart = (short)(this.iNextStart + 1);
        }
        if (inWord) {
            int lastIndex = this.iNextStart;
            if (this.textArray[this.iNextStart - 1] == '\u00ad') {
                --lastIndex;
            }
            int wordLength = lastIndex - this.iThisStart;
            boolean kerning = this.font.hasKerning();
            MinOptMax wordIPD = new MinOptMax(0);
            for (int i = this.iThisStart; i < lastIndex; ++i) {
                char previous;
                char c = this.textArray[i];
                int charWidth = this.font.getCharWidth(c);
                wordIPD.add(charWidth);
                if (!kerning) continue;
                int kern = 0;
                if (i > this.iThisStart) {
                    previous = this.textArray[i - 1];
                    kern = this.font.getKernValue(previous, c) * this.font.getFontSize() / 1000;
                } else if (prevAi != null && !prevAi.isSpace) {
                    previous = this.textArray[prevAi.iBreakIndex - 1];
                    kern = this.font.getKernValue(previous, c) * this.font.getFontSize() / 1000;
                }
                if (kern == 0) continue;
                this.addToLetterAdjust(i, kern);
                wordIPD.add(kern);
            }
            int iLetterSpaces = wordLength - 1;
            wordIPD.add(MinOptMax.multiply(this.letterSpaceIPD, iLetterSpaces));
            ai = new AreaInfo(this.iThisStart, (short)lastIndex, 0, (short)iLetterSpaces, wordIPD, false, false, false);
            this.vecAreaInfo.add(ai);
            this.iTempStart = this.iNextStart;
            sequence.addAll(this.createElementsForAWordFragment(alignment, ai, this.vecAreaInfo.size() - 1, this.letterSpaceIPD));
            ai = null;
        } else if (inWhitespace) {
            ai = new AreaInfo(this.iThisStart, this.iNextStart, (short)(this.iNextStart - this.iThisStart), 0, MinOptMax.multiply(this.wordSpaceIPD, this.iNextStart - this.iThisStart), false, true, true);
            this.vecAreaInfo.add(ai);
            sequence.addAll(this.createElementsForASpace(alignment, ai, this.vecAreaInfo.size() - 1));
            ai = null;
        } else if (ai != null) {
            this.vecAreaInfo.add(ai);
            ai.breakOppAfter = ch == '\u200b';
            sequence.addAll(this.createElementsForASpace(alignment, ai, this.vecAreaInfo.size() - 1));
            ai = null;
        } else if (ch == '\n') {
            if (this.lineEndBAP != 0) {
                sequence.add(new KnuthGlue(this.lineEndBAP, 0, 0, new LeafPosition(this, -1), true));
            }
            ((KnuthSequence)sequence).endSequence();
            sequence = new InlineKnuthSequence();
            returnList.add(sequence);
        }
        if (((List)returnList.getLast()).size() == 0) {
            returnList.removeLast();
        }
        this.setFinished(true);
        if (returnList.size() > 0) {
            return returnList;
        }
        return null;
    }

    public List addALetterSpaceTo(List oldList) {
        ListIterator<KnuthElement> oldListIterator = oldList.listIterator();
        KnuthElement el = (KnuthElement)oldListIterator.next();
        LeafPosition pos = (LeafPosition)((KnuthBox)el).getPosition();
        int idx = pos.getLeafPos();
        if (idx > -1) {
            AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(idx);
            AreaInfo.access$108(ai);
            ai.ipdArea.add(this.letterSpaceIPD);
            if (BREAK_CHARS.indexOf(this.textArray[this.iTempStart - 1]) >= 0) {
                oldListIterator = oldList.listIterator(oldList.size());
                oldListIterator.add(new KnuthPenalty(0, 50, true, new LeafPosition(this, -1), false));
                oldListIterator.add(new KnuthGlue(this.letterSpaceIPD.opt, this.letterSpaceIPD.max - this.letterSpaceIPD.opt, this.letterSpaceIPD.opt - this.letterSpaceIPD.min, new LeafPosition(this, -1), false));
            } else if (this.letterSpaceIPD.min == this.letterSpaceIPD.max) {
                oldListIterator.set(new KnuthInlineBox(((AreaInfo)ai).ipdArea.opt, this.alignmentContext, pos, false));
            } else {
                oldListIterator.next();
                oldListIterator.next();
                oldListIterator.set(new KnuthGlue(ai.iLScount * this.letterSpaceIPD.opt, ai.iLScount * (this.letterSpaceIPD.max - this.letterSpaceIPD.opt), ai.iLScount * (this.letterSpaceIPD.opt - this.letterSpaceIPD.min), new LeafPosition(this, -1), true));
            }
        }
        return oldList;
    }

    public void removeWordSpace(List oldList) {
        int leafValue;
        ListIterator oldListIterator = oldList.listIterator();
        if (((KnuthElement)((LinkedList)oldList).getFirst()).isPenalty()) {
            oldListIterator.next();
        }
        if (oldList.size() > 2) {
            oldListIterator.next();
            oldListIterator.next();
        }
        if ((leafValue = ((LeafPosition)((KnuthElement)oldListIterator.next()).getPosition()).getLeafPos()) == this.vecAreaInfo.size() - 1) {
            this.vecAreaInfo.remove(leafValue);
        } else {
            log.error("trying to remove a non-trailing word space");
        }
    }

    public void hyphenate(Position pos, HyphContext hc) {
        AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(((LeafPosition)pos).getLeafPos());
        int iStartIndex = ai.iStartIndex;
        boolean bNothingChanged = true;
        while (iStartIndex < ai.iBreakIndex) {
            boolean bHyphenFollows;
            int iStopIndex;
            MinOptMax newIPD = new MinOptMax(0);
            if (hc.hasMoreHyphPoints() && (iStopIndex = iStartIndex + hc.getNextHyphPoint()) <= ai.iBreakIndex) {
                bHyphenFollows = true;
            } else {
                bHyphenFollows = false;
                iStopIndex = ai.iBreakIndex;
            }
            hc.updateOffset(iStopIndex - iStartIndex);
            for (int i = iStartIndex; i < iStopIndex; ++i) {
                char c = this.textArray[i];
                newIPD.add(new MinOptMax(this.font.getCharWidth(c)));
                if (i >= iStopIndex) continue;
                MinOptMax la = this.letterAdjustArray[i + 1];
                if (i == iStopIndex - 1 && bHyphenFollows) {
                    la = null;
                }
                if (la == null) continue;
                newIPD.add(la);
            }
            boolean bIsWordEnd = iStopIndex == ai.iBreakIndex && ai.iLScount < ai.iBreakIndex - ai.iStartIndex;
            newIPD.add(MinOptMax.multiply(this.letterSpaceIPD, bIsWordEnd ? iStopIndex - iStartIndex - 1 : iStopIndex - iStartIndex));
            if (!bNothingChanged || iStopIndex != ai.iBreakIndex || bHyphenFollows) {
                if (this.changeList == null) {
                    this.changeList = new LinkedList();
                }
                this.changeList.add(new PendingChange(new AreaInfo((short)iStartIndex, (short)iStopIndex, 0, (short)(bIsWordEnd ? iStopIndex - iStartIndex - 1 : iStopIndex - iStartIndex), newIPD, bHyphenFollows, false, false), ((LeafPosition)pos).getLeafPos()));
                bNothingChanged = false;
            }
            iStartIndex = iStopIndex;
        }
        if (!this.bChanged && !bNothingChanged) {
            this.bChanged = true;
        }
    }

    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        if (this.changeList != null) {
            int iAddedAI = 0;
            int iRemovedAI = 0;
            int iOldIndex = -1;
            PendingChange currChange = null;
            ListIterator changeListIterator = this.changeList.listIterator();
            while (changeListIterator.hasNext()) {
                currChange = (PendingChange)changeListIterator.next();
                if (currChange.index != iOldIndex) {
                    iOldIndex = currChange.index;
                    this.vecAreaInfo.remove(currChange.index + ++iAddedAI - ++iRemovedAI);
                    this.vecAreaInfo.add(currChange.index + iAddedAI - iRemovedAI, currChange.ai);
                    continue;
                }
                this.vecAreaInfo.add(currChange.index + ++iAddedAI - iRemovedAI, currChange.ai);
            }
            this.changeList.clear();
        }
        this.iReturnedIndex = 0;
        return this.bChanged;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList returnList = new LinkedList();
        while (this.iReturnedIndex < this.vecAreaInfo.size()) {
            AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(this.iReturnedIndex);
            if (ai.iWScount == 0) {
                returnList.addAll(this.createElementsForAWordFragment(alignment, ai, this.iReturnedIndex, this.letterSpaceIPD));
            } else {
                returnList.addAll(this.createElementsForASpace(alignment, ai, this.iReturnedIndex));
            }
            ++this.iReturnedIndex;
        }
        this.setFinished(true);
        return returnList;
    }

    public void getWordChars(StringBuffer sbChars, Position pos) {
        int iLeafValue = ((LeafPosition)pos).getLeafPos();
        if (iLeafValue != -1) {
            AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(iLeafValue);
            sbChars.append(new String(this.textArray, (int)ai.iStartIndex, ai.iBreakIndex - ai.iStartIndex));
        }
    }

    private LinkedList createElementsForASpace(int alignment, AreaInfo ai, int leafValue) {
        LinkedList<KnuthElement> spaceElements = new LinkedList<KnuthElement>();
        LeafPosition mainPosition = new LeafPosition(this, leafValue);
        if (!ai.breakOppAfter) {
            if (alignment == 70) {
                spaceElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
                spaceElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt, ((AreaInfo)ai).ipdArea.max - ((AreaInfo)ai).ipdArea.opt, ((AreaInfo)ai).ipdArea.opt - ((AreaInfo)ai).ipdArea.min, mainPosition, false));
            } else {
                spaceElements.add(new KnuthInlineBox(((AreaInfo)ai).ipdArea.opt, null, mainPosition, true));
            }
        } else if (this.textArray[ai.iStartIndex] != ' ' || this.foText.getWhitespaceTreatment() == 108) {
            switch (alignment) {
                case 23: {
                    spaceElements.add(new KnuthGlue(this.lineEndBAP, 10008, 0, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(-(this.lineStartBAP + this.lineEndBAP), -20016, 0, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                    spaceElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt + this.lineStartBAP, 10008, 0, mainPosition, false));
                    break;
                }
                case 39: 
                case 135: {
                    spaceElements.add(new KnuthGlue(this.lineEndBAP, 10008, 0, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(-(this.lineStartBAP + this.lineEndBAP), -10008, 0, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                    spaceElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt + this.lineStartBAP, 0, 0, mainPosition, false));
                    break;
                }
                case 70: {
                    spaceElements.add(new KnuthGlue(this.lineEndBAP, 0, 0, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(-(this.lineStartBAP + this.lineEndBAP), ((AreaInfo)ai).ipdArea.max - ((AreaInfo)ai).ipdArea.opt, ((AreaInfo)ai).ipdArea.opt - ((AreaInfo)ai).ipdArea.min, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                    spaceElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(this.lineStartBAP + ((AreaInfo)ai).ipdArea.opt, 0, 0, mainPosition, false));
                    break;
                }
                default: {
                    spaceElements.add(new KnuthGlue(this.lineEndBAP, 0, 0, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(-(this.lineStartBAP + this.lineEndBAP), ((AreaInfo)ai).ipdArea.max - ((AreaInfo)ai).ipdArea.opt, 0, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                    spaceElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(this.lineStartBAP + ((AreaInfo)ai).ipdArea.opt, 0, 0, mainPosition, false));
                    break;
                }
            }
        } else {
            switch (alignment) {
                case 23: {
                    spaceElements.add(new KnuthGlue(this.lineEndBAP, 10008, 0, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt - (this.lineStartBAP + this.lineEndBAP), -20016, 0, mainPosition, false));
                    spaceElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                    spaceElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(this.lineStartBAP, 10008, 0, new LeafPosition(this, -1), false));
                    break;
                }
                case 39: 
                case 135: {
                    if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                        spaceElements.add(new KnuthGlue(this.lineEndBAP, 10008, 0, new LeafPosition(this, -1), false));
                        spaceElements.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), false));
                        spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt - (this.lineStartBAP + this.lineEndBAP), -10008, 0, mainPosition, false));
                        spaceElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                        spaceElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                        spaceElements.add(new KnuthGlue(this.lineStartBAP, 0, 0, new LeafPosition(this, -1), false));
                        break;
                    }
                    spaceElements.add(new KnuthGlue(0, 10008, 0, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), false));
                    spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt, -10008, 0, mainPosition, false));
                    break;
                }
                case 70: {
                    if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                        spaceElements.add(new KnuthGlue(this.lineEndBAP, 0, 0, new LeafPosition(this, -1), false));
                        spaceElements.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), false));
                        spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt - (this.lineStartBAP + this.lineEndBAP), ((AreaInfo)ai).ipdArea.max - ((AreaInfo)ai).ipdArea.opt, ((AreaInfo)ai).ipdArea.opt - ((AreaInfo)ai).ipdArea.min, mainPosition, false));
                        spaceElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                        spaceElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                        spaceElements.add(new KnuthGlue(this.lineStartBAP, 0, 0, new LeafPosition(this, -1), false));
                        break;
                    }
                    spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt, ((AreaInfo)ai).ipdArea.max - ((AreaInfo)ai).ipdArea.opt, ((AreaInfo)ai).ipdArea.opt - ((AreaInfo)ai).ipdArea.min, mainPosition, false));
                    break;
                }
                default: {
                    if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                        spaceElements.add(new KnuthGlue(this.lineEndBAP, 0, 0, new LeafPosition(this, -1), false));
                        spaceElements.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), false));
                        spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt - (this.lineStartBAP + this.lineEndBAP), ((AreaInfo)ai).ipdArea.max - ((AreaInfo)ai).ipdArea.opt, 0, mainPosition, false));
                        spaceElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                        spaceElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                        spaceElements.add(new KnuthGlue(this.lineStartBAP, 0, 0, new LeafPosition(this, -1), false));
                        break;
                    }
                    spaceElements.add(new KnuthGlue(((AreaInfo)ai).ipdArea.opt, ((AreaInfo)ai).ipdArea.max - ((AreaInfo)ai).ipdArea.opt, 0, mainPosition, false));
                }
            }
        }
        return spaceElements;
    }

    private LinkedList createElementsForAWordFragment(int alignment, AreaInfo ai, int leafValue, MinOptMax letterSpaceWidth) {
        boolean bSuppressibleLetterSpace;
        LinkedList<KnuthElement> wordElements = new LinkedList<KnuthElement>();
        LeafPosition mainPosition = new LeafPosition(this, leafValue);
        boolean bl = bSuppressibleLetterSpace = ai.breakOppAfter && !ai.bHyphenated;
        if (letterSpaceWidth.min == letterSpaceWidth.max) {
            wordElements.add(new KnuthInlineBox(bSuppressibleLetterSpace ? ((AreaInfo)ai).ipdArea.opt - letterSpaceWidth.opt : ((AreaInfo)ai).ipdArea.opt, this.alignmentContext, this.notifyPos(mainPosition), false));
        } else {
            int unsuppressibleLetterSpaces = bSuppressibleLetterSpace ? ai.iLScount - 1 : ai.iLScount;
            wordElements.add(new KnuthInlineBox(((AreaInfo)ai).ipdArea.opt - ai.iLScount * letterSpaceWidth.opt, this.alignmentContext, this.notifyPos(mainPosition), false));
            wordElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            wordElements.add(new KnuthGlue(unsuppressibleLetterSpaces * letterSpaceWidth.opt, unsuppressibleLetterSpaces * (letterSpaceWidth.max - letterSpaceWidth.opt), unsuppressibleLetterSpaces * (letterSpaceWidth.opt - letterSpaceWidth.min), new LeafPosition(this, -1), true));
            wordElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
        }
        if (ai.bHyphenated) {
            MinOptMax widthIfNoBreakOccurs = null;
            if (ai.iBreakIndex < this.textArray.length) {
                widthIfNoBreakOccurs = this.letterAdjustArray[ai.iBreakIndex];
            }
            wordElements.addAll(this.createElementsForAHyphen(alignment, this.hyphIPD, widthIfNoBreakOccurs, ai.breakOppAfter && ai.bHyphenated));
        } else if (bSuppressibleLetterSpace) {
            wordElements.addAll(this.createElementsForAHyphen(alignment, 0, letterSpaceWidth, true));
        }
        return wordElements;
    }

    private LinkedList createElementsForAHyphen(int alignment, int widthIfBreakOccurs, MinOptMax widthIfNoBreakOccurs, boolean unflagged) {
        if (widthIfNoBreakOccurs == null) {
            widthIfNoBreakOccurs = ZERO_MINOPTMAX;
        }
        LinkedList<KnuthElement> hyphenElements = new LinkedList<KnuthElement>();
        switch (alignment) {
            case 23: {
                hyphenElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
                hyphenElements.add(new KnuthGlue(this.lineEndBAP, 10008, 0, new LeafPosition(this, -1), true));
                hyphenElements.add(new KnuthPenalty(this.hyphIPD, unflagged ? 1 : 50, !unflagged, new LeafPosition(this, -1), false));
                hyphenElements.add(new KnuthGlue(-(this.lineEndBAP + this.lineStartBAP), -20016, 0, new LeafPosition(this, -1), false));
                hyphenElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
                hyphenElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
                hyphenElements.add(new KnuthGlue(this.lineStartBAP, 10008, 0, new LeafPosition(this, -1), true));
                break;
            }
            case 39: 
            case 135: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    hyphenElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
                    hyphenElements.add(new KnuthGlue(this.lineEndBAP, 10008, 0, new LeafPosition(this, -1), false));
                    hyphenElements.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, new LeafPosition(this, -1), false));
                    hyphenElements.add(new KnuthGlue(widthIfNoBreakOccurs.opt - (this.lineStartBAP + this.lineEndBAP), -10008, 0, new LeafPosition(this, -1), false));
                    hyphenElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                    hyphenElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                    hyphenElements.add(new KnuthGlue(this.lineStartBAP, 0, 0, new LeafPosition(this, -1), false));
                    break;
                }
                hyphenElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
                hyphenElements.add(new KnuthGlue(0, 10008, 0, new LeafPosition(this, -1), false));
                hyphenElements.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, new LeafPosition(this, -1), false));
                hyphenElements.add(new KnuthGlue(widthIfNoBreakOccurs.opt, -10008, 0, new LeafPosition(this, -1), false));
                break;
            }
            default: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    hyphenElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
                    hyphenElements.add(new KnuthGlue(this.lineEndBAP, 0, 0, new LeafPosition(this, -1), false));
                    hyphenElements.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, new LeafPosition(this, -1), false));
                    if (widthIfNoBreakOccurs.min != 0 || widthIfNoBreakOccurs.max != 0) {
                        hyphenElements.add(new KnuthGlue(widthIfNoBreakOccurs.opt - (this.lineStartBAP + this.lineEndBAP), widthIfNoBreakOccurs.max - widthIfNoBreakOccurs.opt, widthIfNoBreakOccurs.opt - widthIfNoBreakOccurs.min, new LeafPosition(this, -1), false));
                    } else {
                        hyphenElements.add(new KnuthGlue(-(this.lineStartBAP + this.lineEndBAP), 0, 0, new LeafPosition(this, -1), false));
                    }
                    hyphenElements.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), false));
                    hyphenElements.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
                    hyphenElements.add(new KnuthGlue(this.lineStartBAP, 0, 0, new LeafPosition(this, -1), false));
                    break;
                }
                hyphenElements.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, new LeafPosition(this, -1), false));
                if (widthIfNoBreakOccurs.min == 0 && widthIfNoBreakOccurs.max == 0) break;
                hyphenElements.add(new KnuthGlue(widthIfNoBreakOccurs.opt, widthIfNoBreakOccurs.max - widthIfNoBreakOccurs.opt, widthIfNoBreakOccurs.opt - widthIfNoBreakOccurs.min, new LeafPosition(this, -1), false));
            }
        }
        return hyphenElements;
    }

    private class PendingChange {
        public AreaInfo ai;
        public int index;

        public PendingChange(AreaInfo ai, int index) {
            this.ai = ai;
            this.index = index;
        }
    }

    private class AreaInfo {
        private short iStartIndex;
        private short iBreakIndex;
        private short iWScount;
        private short iLScount;
        private MinOptMax ipdArea;
        private boolean bHyphenated;
        private boolean isSpace;
        private boolean breakOppAfter;

        public AreaInfo(short iSIndex, short iBIndex, short iWS, short iLS, MinOptMax ipd, boolean bHyph, boolean isSpace, boolean breakOppAfter) {
            this.iStartIndex = iSIndex;
            this.iBreakIndex = iBIndex;
            this.iWScount = iWS;
            this.iLScount = iLS;
            this.ipdArea = ipd;
            this.bHyphenated = bHyph;
            this.isSpace = isSpace;
            this.breakOppAfter = breakOppAfter;
        }

        public String toString() {
            return "[ lscnt=" + this.iLScount + ", wscnt=" + this.iWScount + ", ipd=" + this.ipdArea.toString() + ", sidx=" + this.iStartIndex + ", bidx=" + this.iBreakIndex + ", hyph=" + this.bHyphenated + ", space=" + this.isSpace + "]";
        }

        static /* synthetic */ short access$108(AreaInfo x0) {
            short s2 = x0.iLScount;
            x0.iLScount = (short)(s2 + 1);
            return s2;
        }
    }
}

