/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.AbstractRenderer;

public class RendererContext {
    private String mime;
    private AbstractRenderer renderer;
    private FOUserAgent userAgent;
    private Map props = new HashMap();

    public RendererContext(AbstractRenderer renderer, String m4) {
        this.renderer = renderer;
        this.mime = m4;
    }

    public AbstractRenderer getRenderer() {
        return this.renderer;
    }

    public String getMimeType() {
        return this.mime;
    }

    public void setUserAgent(FOUserAgent ua) {
        this.userAgent = ua;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setProperty(String name, Object val) {
        this.props.put(name, val);
    }

    public Object getProperty(String prop) {
        return this.props.get(prop);
    }

    public static RendererContextWrapper wrapRendererContext(RendererContext context) {
        RendererContextWrapper wrapper = new RendererContextWrapper(context);
        return wrapper;
    }

    public static class RendererContextWrapper {
        protected RendererContext context;

        public RendererContextWrapper(RendererContext context) {
            this.context = context;
        }

        public FOUserAgent getUserAgent() {
            return this.context.getUserAgent();
        }

        public int getCurrentXPosition() {
            return (Integer)this.context.getProperty("xpos");
        }

        public int getCurrentYPosition() {
            return (Integer)this.context.getProperty("ypos");
        }

        public int getWidth() {
            return (Integer)this.context.getProperty("width");
        }

        public int getHeight() {
            return (Integer)this.context.getProperty("height");
        }

        public Map getForeignAttributes() {
            return (Map)this.context.getProperty("foreign-attributes");
        }
    }
}

