/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer.pdf.fo;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.AbstractPdfRenderer;
import org.apache.maven.doxia.docrenderer.pdf.PdfRenderer;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.fo.FoAggregateSink;
import org.apache.maven.doxia.module.fo.FoSink;
import org.apache.maven.doxia.module.fo.FoSinkFactory;
import org.apache.maven.doxia.module.fo.FoUtils;
import org.apache.maven.doxia.parser.module.ParserModule;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.xml.sax.SAXParseException;

@Component(role=PdfRenderer.class, hint="fo")
public class FoPdfRenderer
extends AbstractPdfRenderer {
    @Override
    public void generatePdf(File inputFile, File pdfFile) throws DocumentRendererException {
        this.generatePdf(inputFile, pdfFile, null);
    }

    @Override
    public void render(Map<String, ParserModule> filesToProcess, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        this.render(filesToProcess, outputDirectory, documentModel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Map<String, ParserModule> filesToProcess, File outputDirectory, DocumentModel documentModel, DocumentRendererContext context) throws DocumentRendererException, IOException {
        File pdfOutputFile;
        this.copyResources(outputDirectory);
        if (documentModel == null) {
            this.getLogger().debug("No document model, generating all documents individually.");
            this.renderIndividual(filesToProcess, outputDirectory, context);
            return;
        }
        String outputName = this.getOutputName(documentModel);
        File outputFOFile = new File(outputDirectory, outputName + ".fo");
        if (!outputFOFile.getParentFile().exists()) {
            outputFOFile.getParentFile().mkdirs();
        }
        if (!(pdfOutputFile = new File(outputDirectory, outputName + ".pdf")).getParentFile().exists()) {
            pdfOutputFile.getParentFile().mkdirs();
        }
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter(outputFOFile);
            FoAggregateSink sink = new FoAggregateSink(writer);
            File fOConfigFile = new File(outputDirectory, "pdf-config.xml");
            if (fOConfigFile.exists()) {
                sink.load(fOConfigFile);
                this.getLogger().debug("Loaded pdf config file: " + fOConfigFile.getAbsolutePath());
            }
            String generateTOC = context != null && context.get("generateTOC") != null ? context.get("generateTOC").toString().trim() : "start";
            int tocPosition = 0;
            tocPosition = "start".equalsIgnoreCase(generateTOC) ? 1 : ("end".equalsIgnoreCase(generateTOC) ? 2 : 0);
            sink.setDocumentModel(documentModel, tocPosition);
            sink.beginDocument();
            sink.coverPage();
            if (tocPosition == 1) {
                sink.toc();
            }
            if (documentModel.getToc() == null || documentModel.getToc().getItems() == null) {
                this.getLogger().info("No TOC is defined in the document descriptor. Merging all documents.");
                this.mergeAllSources(filesToProcess, sink, context);
            } else {
                this.getLogger().debug("Using TOC defined in the document descriptor.");
                this.mergeSourcesFromTOC(documentModel.getToc(), sink, context);
            }
            if (tocPosition == 2) {
                sink.toc();
            }
            sink.endDocument();
        }
        finally {
            IOUtil.close(writer);
        }
        this.generatePdf(outputFOFile, pdfOutputFile, documentModel);
    }

    @Override
    public void renderIndividual(Map<String, ParserModule> filesToProcess, File outputDirectory) throws DocumentRendererException, IOException {
        this.renderIndividual(filesToProcess, outputDirectory, null);
    }

    @Override
    public void renderIndividual(Map<String, ParserModule> filesToProcess, File outputDirectory, DocumentRendererContext context) throws DocumentRendererException, IOException {
        for (Map.Entry<String, ParserModule> entry : filesToProcess.entrySet()) {
            File pdfOutputFile;
            String key = entry.getKey();
            ParserModule module = entry.getValue();
            File fullDoc = new File(this.getBaseDir(), module.getSourceDirectory() + File.separator + key);
            String output = key;
            for (String extension : module.getExtensions()) {
                String lowerCaseExtension = extension.toLowerCase(Locale.ENGLISH);
                if (output.toLowerCase(Locale.ENGLISH).indexOf("." + lowerCaseExtension) == -1) continue;
                output = output.substring(0, output.toLowerCase(Locale.ENGLISH).indexOf("." + lowerCaseExtension));
            }
            File outputFOFile = new File(outputDirectory, output + ".fo");
            if (!outputFOFile.getParentFile().exists()) {
                outputFOFile.getParentFile().mkdirs();
            }
            if (!(pdfOutputFile = new File(outputDirectory, output + ".pdf")).getParentFile().exists()) {
                pdfOutputFile.getParentFile().mkdirs();
            }
            FoSink sink = (FoSink)new FoSinkFactory().createSink(outputFOFile.getParentFile(), outputFOFile.getName());
            sink.beginDocument();
            this.parse(fullDoc.getAbsolutePath(), module.getParserId(), sink, context);
            sink.endDocument();
            this.generatePdf(outputFOFile, pdfOutputFile, null);
        }
    }

    private void mergeAllSources(Map<String, ParserModule> filesToProcess, FoAggregateSink sink, DocumentRendererContext context) throws DocumentRendererException, IOException {
        for (Map.Entry<String, ParserModule> entry : filesToProcess.entrySet()) {
            String key = entry.getKey();
            ParserModule module = entry.getValue();
            sink.setDocumentName(key);
            File fullDoc = new File(this.getBaseDir(), module.getSourceDirectory() + File.separator + key);
            this.parse(fullDoc.getAbsolutePath(), module.getParserId(), sink, context);
        }
    }

    private void mergeSourcesFromTOC(DocumentTOC toc, FoAggregateSink sink, DocumentRendererContext context) throws IOException, DocumentRendererException {
        this.parseTocItems(toc.getItems(), sink, context);
    }

    private void parseTocItems(List<DocumentTOCItem> items, FoAggregateSink sink, DocumentRendererContext context) throws IOException, DocumentRendererException {
        for (DocumentTOCItem tocItem : items) {
            if (tocItem.getRef() == null) {
                if (!this.getLogger().isInfoEnabled()) continue;
                this.getLogger().info("No ref defined for tocItem " + tocItem.getName());
                continue;
            }
            String href = StringUtils.replace(tocItem.getRef(), "\\", "/");
            if (href.lastIndexOf(46) != -1) {
                href = href.substring(0, href.lastIndexOf(46));
            }
            this.renderModules(href, sink, tocItem, context);
            if (tocItem.getItems() == null) continue;
            this.parseTocItems(tocItem.getItems(), sink, context);
        }
    }

    private void renderModules(String href, FoAggregateSink sink, DocumentTOCItem tocItem, DocumentRendererContext context) throws DocumentRendererException, IOException {
        Collection<ParserModule> modules = this.parserModuleManager.getParserModules();
        for (ParserModule module : modules) {
            File moduleBasedir = new File(this.getBaseDir(), module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            for (String extension : module.getExtensions()) {
                String doc = href + "." + extension;
                File source = new File(moduleBasedir, doc);
                if (!source.exists()) {
                    doc = href.indexOf("." + extension) != -1 ? href + ".vm" : href + "." + extension + ".vm";
                    source = new File(moduleBasedir, doc);
                }
                if (!source.exists()) continue;
                sink.setDocumentName(doc);
                sink.setDocumentTitle(tocItem.getName());
                this.parse(source.getPath(), module.getParserId(), sink, context);
            }
        }
    }

    private void generatePdf(File inputFile, File pdfFile, DocumentModel documentModel) throws DocumentRendererException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Generating: " + pdfFile);
        }
        try {
            FoUtils.convertFO2PDF(inputFile, pdfFile, null, documentModel);
        }
        catch (TransformerException e) {
            if (e.getCause() != null && e.getCause() instanceof SAXParseException) {
                SAXParseException sax = (SAXParseException)e.getCause();
                StringBuilder sb = new StringBuilder();
                sb.append("Error creating PDF from ").append(inputFile.getAbsolutePath()).append(":").append(sax.getLineNumber()).append(":").append(sax.getColumnNumber()).append("\n");
                sb.append(e.getMessage());
                throw new DocumentRendererException(sb.toString());
            }
            throw new DocumentRendererException("Error creating PDF from " + inputFile + ": " + e.getMessage());
        }
    }
}

