/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.markup.XmlMarkup;
import org.apache.maven.doxia.sink.impl.SinkAdapter;
import org.apache.maven.doxia.sink.impl.SinkUtils;

public abstract class AbstractXmlSink
extends SinkAdapter
implements XmlMarkup {
    private String nameSpace;
    private boolean firstTag = true;
    private boolean insertNewline = true;

    public void setInsertNewline(boolean insertNewline) {
        this.insertNewline = insertNewline;
    }

    public void setNameSpace(String ns) {
        this.nameSpace = ns;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    protected void writeStartTag(HTML.Tag t2) {
        this.writeStartTag(t2, null);
    }

    protected void writeStartTag(HTML.Tag t2, MutableAttributeSet att) {
        this.writeStartTag(t2, att, false);
    }

    protected void writeStartTag(HTML.Tag t2, MutableAttributeSet att, boolean isSimpleTag) {
        if (t2 == null) {
            throw new IllegalArgumentException("A tag is required");
        }
        StringBuilder sb = new StringBuilder();
        if (this.insertNewline && t2.isBlock() && !this.firstTag) {
            sb.append(EOL);
        }
        this.firstTag = false;
        sb.append('<');
        if (this.nameSpace != null) {
            sb.append(this.nameSpace).append(':');
        }
        sb.append(t2.toString());
        sb.append(SinkUtils.getAttributeString(att));
        if (isSimpleTag) {
            sb.append(' ').append('/');
        }
        sb.append('>');
        this.write(sb.toString());
    }

    protected void writeEOL() {
        this.write(EOL);
    }

    protected void writeEndTag(HTML.Tag t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("A tag is required");
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append('/');
        if (this.nameSpace != null) {
            sb.append(this.nameSpace).append(':');
        }
        sb.append(t2.toString());
        sb.append('>');
        this.write(sb.toString());
    }

    protected void writeSimpleTag(HTML.Tag t2) {
        this.writeSimpleTag(t2, null);
    }

    protected void writeSimpleTag(HTML.Tag t2, MutableAttributeSet att) {
        this.writeStartTag(t2, att, true);
    }

    protected abstract void write(String var1);
}

