/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting.exec;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.reporting.exec.MavenPluginManagerHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;

@Component(role=MavenPluginManagerHelper.class)
public class DefaultMavenPluginManagerHelper
implements MavenPluginManagerHelper {
    @Requirement
    private Logger logger;
    @Requirement
    protected MavenPluginManager mavenPluginManager;
    private Boolean isEclipseAether;
    private Method setupPluginRealm;
    private Method getPluginDescriptor;
    private Method getRepositorySession;

    public DefaultMavenPluginManagerHelper() {
        try {
            for (Method m4 : MavenPluginManager.class.getMethods()) {
                if ("setupPluginRealm".equals(m4.getName())) {
                    this.setupPluginRealm = m4;
                    continue;
                }
                if (!"getPluginDescriptor".equals(m4.getName())) continue;
                this.getPluginDescriptor = m4;
            }
        }
        catch (SecurityException e) {
            this.logger.warn("unable to find MavenPluginManager.setupPluginRealm() method", e);
        }
        try {
            for (Method m4 : MavenSession.class.getMethods()) {
                if (!"getRepositorySession".equals(m4.getName())) continue;
                this.getRepositorySession = m4;
                break;
            }
        }
        catch (SecurityException e) {
            this.logger.warn("unable to find MavenSession.getRepositorySession() method", e);
        }
    }

    private boolean isEclipseAether() {
        if (this.isEclipseAether == null) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                cl.loadClass("org.sonatype.aether.graph.DependencyFilter");
                this.isEclipseAether = false;
            }
            catch (ClassNotFoundException e) {
                this.isEclipseAether = true;
            }
        }
        return this.isEclipseAether;
    }

    private Object createExclusionsDependencyFilter(List<String> artifactIdsList) {
        if (this.isEclipseAether()) {
            return new ExclusionsDependencyFilter(artifactIdsList);
        }
        return new org.sonatype.aether.util.filter.ExclusionsDependencyFilter(artifactIdsList);
    }

    @Override
    public PluginDescriptor getPluginDescriptor(Plugin plugin, MavenSession session) throws PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        try {
            Object repositorySession = this.getRepositorySession.invoke((Object)session, new Object[0]);
            List remoteRepositories = session.getCurrentProject().getRemotePluginRepositories();
            return (PluginDescriptor)this.getPluginDescriptor.invoke((Object)this.mavenPluginManager, plugin, remoteRepositories, repositorySession);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("IllegalArgumentException during MavenPluginManager.getPluginDescriptor() call", e);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("IllegalAccessException during MavenPluginManager.getPluginDescriptor() call", e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof PluginResolutionException) {
                throw (PluginResolutionException)target;
            }
            if (target instanceof PluginDescriptorParsingException) {
                throw (PluginDescriptorParsingException)target;
            }
            if (target instanceof InvalidPluginDescriptorException) {
                throw (InvalidPluginDescriptorException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            this.logger.warn("Exception during MavenPluginManager.getPluginDescriptor() call", e);
        }
        return null;
    }

    @Override
    public void setupPluginRealm(PluginDescriptor pluginDescriptor, MavenSession session, ClassLoader parent, List<String> imports, List<String> excludeArtifactIds) throws PluginResolutionException, PluginContainerException {
        try {
            this.setupPluginRealm.invoke((Object)this.mavenPluginManager, pluginDescriptor, session, parent, imports, this.createExclusionsDependencyFilter(excludeArtifactIds));
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("IllegalArgumentException during MavenPluginManager.setupPluginRealm() call", e);
        }
        catch (IllegalAccessException e) {
            this.logger.warn("IllegalAccessException during MavenPluginManager.setupPluginRealm() call", e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof PluginResolutionException) {
                throw (PluginResolutionException)target;
            }
            if (target instanceof PluginContainerException) {
                throw (PluginContainerException)target;
            }
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            this.logger.warn("Exception during MavenPluginManager.setupPluginRealm() call", e);
        }
    }
}

