/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.mock;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.struts.mock.MockEnumeration;

public class MockPageContext
extends PageContext {
    protected ServletContext application = null;
    protected HashMap attributes = new HashMap();
    protected ServletConfig config = null;
    protected ServletRequest request = null;
    protected ServletResponse response = null;
    protected HttpSession session = null;
    private boolean throwIOException;
    private boolean returnBodyContent;

    public MockPageContext() {
    }

    public MockPageContext(ServletConfig config, ServletRequest request, ServletResponse response) {
        this.setValues(config, request, response);
    }

    public MockPageContext(boolean throwIOException, boolean returnBody) {
        this.throwIOException = throwIOException;
        this.returnBodyContent = returnBody;
    }

    private void checkAndThrow() throws IOException {
        if (this.throwIOException) {
            throw new IOException();
        }
    }

    public void setValues(ServletConfig config, ServletRequest request, ServletResponse response) {
        this.config = config;
        this.application = config != null ? config.getServletContext() : null;
        this.request = request;
        this.response = response;
        this.session = request != null ? ((HttpServletRequest)request).getSession(false) : null;
    }

    public Object findAttribute(String name) {
        Object value = this.getAttribute(name, 1);
        if (value == null) {
            value = this.getAttribute(name, 2);
        }
        if (value == null) {
            value = this.getAttribute(name, 3);
        }
        if (value == null) {
            value = this.getAttribute(name, 4);
        }
        return value;
    }

    public void forward(String path) {
        throw new UnsupportedOperationException();
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 1);
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 1) {
            return this.attributes.get(name);
        }
        if (scope == 2) {
            if (this.request != null) {
                return this.request.getAttribute(name);
            }
            return null;
        }
        if (scope == 3) {
            if (this.session != null) {
                return this.session.getAttribute(name);
            }
            return null;
        }
        if (scope == 4) {
            if (this.application != null) {
                return this.application.getAttribute(name);
            }
            return null;
        }
        throw new IllegalArgumentException("Invalid scope " + scope);
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        if (scope == 1) {
            return new MockEnumeration(this.attributes.keySet().iterator());
        }
        if (scope == 2) {
            if (this.request != null) {
                return this.request.getAttributeNames();
            }
            return new MockEnumeration(Collections.EMPTY_LIST.iterator());
        }
        if (scope == 3) {
            if (this.session != null) {
                return this.session.getAttributeNames();
            }
            return new MockEnumeration(Collections.EMPTY_LIST.iterator());
        }
        if (scope == 4) {
            if (this.application != null) {
                return this.application.getAttributeNames();
            }
            return new MockEnumeration(Collections.EMPTY_LIST.iterator());
        }
        throw new IllegalArgumentException("Invalid scope " + scope);
    }

    public int getAttributesScope(String name) {
        if (this.attributes.get(name) != null) {
            return 1;
        }
        if (this.request != null && this.request.getAttribute(name) != null) {
            return 2;
        }
        if (this.session != null && this.session.getAttribute(name) != null) {
            return 3;
        }
        if (this.application != null && this.application.getAttribute(name) != null) {
            return 4;
        }
        return 0;
    }

    public Exception getException() {
        throw new UnsupportedOperationException();
    }

    public JspWriter getOut() {
        JspWriter jspWriter = new JspWriter(0, false){

            public void print(String s2) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void newLine() throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void print(boolean b) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void print(char c) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void print(int i) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void print(long l) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void print(float f) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void print(double d) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void print(char[] s2) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void print(Object obj) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println() throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println(boolean x) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println(char x) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println(int x) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println(long x) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println(float x) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println(double x) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println(char[] x) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println(String x) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void println(Object x) throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void clear() throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void clearBuffer() throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void flush() throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public void close() throws IOException {
                MockPageContext.this.checkAndThrow();
            }

            public int getRemaining() {
                return 0;
            }

            public void write(char[] cbuf, int off, int len) throws IOException {
                MockPageContext.this.checkAndThrow();
            }
        };
        if (this.returnBodyContent) {
            return new BodyContent(jspWriter){

                public Reader getReader() {
                    return null;
                }

                public String getString() {
                    return null;
                }

                public void writeOut(Writer out) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void newLine() throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void print(boolean b) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void print(char c) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void print(int i) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void print(long l) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void print(float f) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void print(double d) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void print(char[] s2) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void print(String s2) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void print(Object obj) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println() throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println(boolean x) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println(char x) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println(int x) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println(long x) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println(float x) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println(double x) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println(char[] x) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println(String x) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void println(Object x) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void clear() throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void clearBuffer() throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public void close() throws IOException {
                    MockPageContext.this.checkAndThrow();
                }

                public int getRemaining() {
                    return 0;
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                    MockPageContext.this.checkAndThrow();
                }
            };
        }
        return jspWriter;
    }

    public Object getPage() {
        throw new UnsupportedOperationException();
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void handlePageException(Exception e) {
        throw new UnsupportedOperationException();
    }

    public void handlePageException(Throwable t2) {
        throw new UnsupportedOperationException();
    }

    public void include(String path) {
        throw new UnsupportedOperationException();
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        throw new UnsupportedOperationException();
    }

    public JspWriter popBody() {
        throw new UnsupportedOperationException();
    }

    public BodyContent pushBody() {
        throw new UnsupportedOperationException();
    }

    public void release() {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String name) {
        int scope = this.getAttributesScope(name);
        if (scope != 0) {
            this.removeAttribute(name, scope);
        }
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 1) {
            this.attributes.remove(name);
        } else if (scope == 2) {
            if (this.request != null) {
                this.request.removeAttribute(name);
            }
        } else if (scope == 3) {
            if (this.session != null) {
                this.session.removeAttribute(name);
            }
        } else if (scope == 4) {
            if (this.application != null) {
                this.application.removeAttribute(name);
            }
        } else {
            throw new IllegalArgumentException("Invalid scope " + scope);
        }
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 1);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 1) {
            this.attributes.put(name, value);
        } else if (scope == 2) {
            if (this.request != null) {
                this.request.setAttribute(name, value);
            }
        } else if (scope == 3) {
            if (this.session != null) {
                this.session.setAttribute(name, value);
            }
        } else if (scope == 4) {
            if (this.application != null) {
                this.application.setAttribute(name, value);
            }
        } else {
            throw new IllegalArgumentException("Invalid scope " + scope);
        }
    }
}

