/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.util.ResponseUtils;

public class TagUtils {
    private static TagUtils instance = new TagUtils();
    private static final Log log = LogFactory.getLog(TagUtils.class);
    private static final MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.LocalStrings");
    private static final Map scopes = new HashMap();

    protected TagUtils() {
    }

    public static TagUtils getInstance() {
        return instance;
    }

    public static void setInstance(TagUtils instance) {
        TagUtils.instance = instance;
    }

    public Map computeParameters(PageContext pageContext, String paramId, String paramName, String paramProperty, String paramScope, String name, String property, String scope, boolean transaction) throws JspException {
        if (paramId == null && name == null && !transaction) {
            return null;
        }
        Map map = null;
        try {
            if (name != null) {
                map = (Map)TagUtils.getInstance().lookup(pageContext, name, property, scope);
            }
        }
        catch (JspException e) {
            this.saveException(pageContext, e);
            throw e;
        }
        HashMap<String, Object> results = null;
        results = map != null ? new HashMap(map) : new HashMap<String, Object>();
        if (paramId != null && paramName != null) {
            Object paramValue = null;
            try {
                paramValue = TagUtils.getInstance().lookup(pageContext, paramName, paramProperty, paramScope);
            }
            catch (JspException e) {
                this.saveException(pageContext, e);
                throw e;
            }
            if (paramValue != null) {
                String paramString = null;
                paramString = paramValue instanceof String ? (String)paramValue : paramValue.toString();
                Object mapValue = results.get(paramId);
                if (mapValue == null) {
                    results.put(paramId, paramString);
                } else if (mapValue instanceof String[]) {
                    String[] oldValues = (String[])mapValue;
                    String[] newValues = new String[oldValues.length + 1];
                    System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                    newValues[oldValues.length] = paramString;
                    results.put(paramId, newValues);
                } else {
                    String[] newValues = new String[]{mapValue.toString(), paramString};
                    results.put(paramId, newValues);
                }
            }
        }
        if (transaction) {
            HttpSession session = pageContext.getSession();
            String token = null;
            if (session != null) {
                token = (String)session.getAttribute("org.apache.struts.action.TOKEN");
            }
            if (token != null) {
                results.put("org.apache.struts.taglib.html.TOKEN", token);
            }
        }
        return results;
    }

    public String computeURL(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect) throws MalformedURLException {
        return this.computeURLWithCharEncoding(pageContext, forward, href, page, action, module, params, anchor, redirect, false);
    }

    public String computeURLWithCharEncoding(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect, boolean useLocalEncoding) throws MalformedURLException {
        return this.computeURLWithCharEncoding(pageContext, forward, href, page, action, module, params, anchor, redirect, true, useLocalEncoding);
    }

    public String computeURL(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect, boolean encodeSeparator) throws MalformedURLException {
        return this.computeURLWithCharEncoding(pageContext, forward, href, page, action, module, params, anchor, redirect, encodeSeparator, false);
    }

    public String computeURLWithCharEncoding(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect, boolean encodeSeparator, boolean useLocalEncoding) throws MalformedURLException {
        String temp;
        String charEncoding = "UTF-8";
        if (useLocalEncoding) {
            charEncoding = pageContext.getResponse().getCharacterEncoding();
        }
        int n = 0;
        if (forward != null) {
            ++n;
        }
        if (href != null) {
            ++n;
        }
        if (page != null) {
            ++n;
        }
        if (action != null) {
            ++n;
        }
        if (n != 1) {
            throw new MalformedURLException(messages.getMessage("computeURL.specifier"));
        }
        ModuleConfig moduleConfig = this.getModuleConfig(module, pageContext);
        StringBuffer url = new StringBuffer();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        if (forward != null) {
            ForwardConfig forwardConfig = moduleConfig.findForwardConfig(forward);
            if (forwardConfig == null) {
                throw new MalformedURLException(messages.getMessage("computeURL.forward", (Object)forward));
            }
            if (forwardConfig.getPath().startsWith("/")) {
                url.append(request.getContextPath());
                url.append(RequestUtils.forwardURL(request, forwardConfig, moduleConfig));
            } else {
                url.append(forwardConfig.getPath());
            }
        } else if (href != null) {
            url.append(href);
        } else if (action != null) {
            ActionServlet servlet = (ActionServlet)((Object)pageContext.getServletContext().getAttribute("org.apache.struts.action.ACTION_SERVLET"));
            String actionIdPath = RequestUtils.actionIdURL(action, moduleConfig, servlet);
            if (actionIdPath != null) {
                action = actionIdPath;
                url.append(request.getContextPath());
                url.append(actionIdPath);
            } else {
                url.append(instance.getActionMappingURL(action, module, pageContext, false));
            }
        } else {
            url.append(request.getContextPath());
            url.append(this.pageURL(request, page, moduleConfig));
        }
        if (anchor != null) {
            temp = url.toString();
            int hash = temp.indexOf(35);
            if (hash >= 0) {
                url.setLength(hash);
            }
            url.append('#');
            url.append(this.encodeURL(anchor, charEncoding));
        }
        if (params != null && params.size() > 0) {
            temp = url.toString();
            int hash = temp.indexOf(35);
            if (hash >= 0) {
                anchor = temp.substring(hash + 1);
                url.setLength(hash);
                temp = url.toString();
            } else {
                anchor = null;
            }
            String separator = null;
            separator = redirect ? "&" : (encodeSeparator ? "&amp;" : "&");
            boolean question = temp.indexOf(63) >= 0;
            Iterator keys = params.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = params.get(key);
                if (value == null) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append(separator);
                    }
                    url.append(this.encodeURL(key, charEncoding));
                    url.append('=');
                    continue;
                }
                if (value instanceof String) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append(separator);
                    }
                    url.append(this.encodeURL(key, charEncoding));
                    url.append('=');
                    url.append(this.encodeURL((String)value, charEncoding));
                    continue;
                }
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    for (int i = 0; i < values.length; ++i) {
                        if (!question) {
                            url.append('?');
                            question = true;
                        } else {
                            url.append(separator);
                        }
                        url.append(this.encodeURL(key, charEncoding));
                        url.append('=');
                        url.append(this.encodeURL(values[i], charEncoding));
                    }
                    continue;
                }
                if (!question) {
                    url.append('?');
                    question = true;
                } else {
                    url.append(separator);
                }
                url.append(this.encodeURL(key, charEncoding));
                url.append('=');
                url.append(this.encodeURL(value.toString(), charEncoding));
            }
            if (anchor != null) {
                url.append('#');
                url.append(this.encodeURL(anchor, charEncoding));
            }
        }
        if (href == null && pageContext.getSession() != null) {
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            if (redirect) {
                return response.encodeRedirectURL(url.toString());
            }
            return response.encodeURL(url.toString());
        }
        return url.toString();
    }

    public String encodeURL(String url) {
        return this.encodeURL(url, "UTF-8");
    }

    public String encodeURL(String url, String enc) {
        return ResponseUtils.encodeURL(url, enc);
    }

    public String filter(String value) {
        return ResponseUtils.filter(value);
    }

    public String getActionMappingName(String action) {
        int pound;
        String value = action;
        int question = action.indexOf("?");
        if (question >= 0) {
            value = value.substring(0, question);
        }
        if ((pound = value.indexOf("#")) >= 0) {
            value = value.substring(0, pound);
        }
        int slash = value.lastIndexOf("/");
        int period = value.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            value = value.substring(0, period);
        }
        return value.startsWith("/") ? value : "/" + value;
    }

    public String getActionMappingURL(String action, PageContext pageContext) {
        return this.getActionMappingURL(action, null, pageContext, false);
    }

    public String getActionMappingURL(String action, String module, PageContext pageContext, boolean contextRelative) {
        String servletMapping;
        ModuleConfig moduleConfig;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String contextPath = request.getContextPath();
        StringBuffer value = new StringBuffer();
        if (contextPath.length() > 1) {
            value.append(contextPath);
        }
        if ((moduleConfig = this.getModuleConfig(module, pageContext)) != null && !contextRelative) {
            value.append(moduleConfig.getPrefix());
        }
        if ((servletMapping = (String)pageContext.getAttribute("org.apache.struts.action.SERVLET_MAPPING", 4)) != null) {
            String queryString = null;
            int question = action.indexOf("?");
            if (question >= 0) {
                queryString = action.substring(question);
            }
            String actionMapping = this.getActionMappingName(action);
            if (servletMapping.startsWith("*.")) {
                value.append(actionMapping);
                value.append(servletMapping.substring(1));
            } else if (servletMapping.endsWith("/*")) {
                value.append(servletMapping.substring(0, servletMapping.length() - 2));
                value.append(actionMapping);
            } else if (servletMapping.equals("/")) {
                value.append(actionMapping);
            }
            if (queryString != null) {
                value.append(queryString);
            }
        } else {
            if (!action.startsWith("/")) {
                value.append("/");
            }
            value.append(action);
        }
        return value.toString();
    }

    public ActionMessages getActionMessages(PageContext pageContext, String paramName) throws JspException {
        ActionMessages am;
        block9: {
            am = new ActionMessages();
            Object value = pageContext.findAttribute(paramName);
            if (value != null) {
                try {
                    if (value instanceof String) {
                        am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage((String)value));
                        break block9;
                    }
                    if (value instanceof String[]) {
                        String[] keys = (String[])value;
                        for (int i = 0; i < keys.length; ++i) {
                            am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(keys[i]));
                        }
                        break block9;
                    }
                    if (value instanceof ActionErrors) {
                        ActionMessages m4 = (ActionMessages)value;
                        am.add(m4);
                        break block9;
                    }
                    if (value instanceof ActionMessages) {
                        am = (ActionMessages)value;
                        break block9;
                    }
                    throw new JspException(messages.getMessage("actionMessages.errors", (Object)value.getClass().getName()));
                }
                catch (JspException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.warn("Unable to retieve ActionMessage for paramName : " + paramName, e);
                }
            }
        }
        return am;
    }

    public ModuleConfig getModuleConfig(PageContext pageContext) {
        return this.getModuleConfig(null, pageContext);
    }

    public ModuleConfig getModuleConfig(String module, PageContext pageContext) {
        ModuleConfig config = ModuleUtils.getInstance().getModuleConfig(module, (HttpServletRequest)pageContext.getRequest(), pageContext.getServletContext());
        if (config == null) {
            throw new NullPointerException("Module '" + module + "' not found.");
        }
        return config;
    }

    public int getScope(String scopeName) throws JspException {
        Integer scope = (Integer)scopes.get(scopeName.toLowerCase());
        if (scope == null) {
            throw new JspException(messages.getMessage("lookup.scope", scope));
        }
        return scope;
    }

    public Locale getUserLocale(PageContext pageContext, String locale) {
        return RequestUtils.getUserLocale((HttpServletRequest)pageContext.getRequest(), locale);
    }

    public boolean isXhtml(PageContext pageContext) {
        String xhtml = (String)pageContext.getAttribute("org.apache.struts.globals.XHTML", 1);
        return "true".equalsIgnoreCase(xhtml);
    }

    public Object lookup(PageContext pageContext, String name, String scopeName) throws JspException {
        if (scopeName == null) {
            return pageContext.findAttribute(name);
        }
        try {
            return pageContext.getAttribute(name, instance.getScope(scopeName));
        }
        catch (JspException e) {
            this.saveException(pageContext, e);
            throw e;
        }
    }

    public Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        Object bean = this.lookup(pageContext, name, scope);
        if (bean == null) {
            JspException e = null;
            e = scope == null ? new JspException(messages.getMessage("lookup.bean.any", (Object)name)) : new JspException(messages.getMessage("lookup.bean", (Object)name, (Object)scope));
            this.saveException(pageContext, e);
            throw e;
        }
        if (property == null) {
            return bean;
        }
        try {
            return PropertyUtils.getProperty(bean, property);
        }
        catch (IllegalAccessException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.access", (Object)property, (Object)name));
        }
        catch (IllegalArgumentException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.argument", (Object)property, (Object)name));
        }
        catch (InvocationTargetException e) {
            Throwable t2 = e.getTargetException();
            if (t2 == null) {
                t2 = e;
            }
            this.saveException(pageContext, t2);
            throw new JspException(messages.getMessage("lookup.target", (Object)property, (Object)name));
        }
        catch (NoSuchMethodException e) {
            Object obj;
            this.saveException(pageContext, e);
            String beanName = name;
            if ("org.apache.struts.taglib.html.BEAN".equals(name) && (obj = pageContext.findAttribute("org.apache.struts.taglib.html.BEAN")) != null) {
                beanName = obj.getClass().getName();
            }
            throw new JspException(messages.getMessage("lookup.method", (Object)property, (Object)beanName));
        }
    }

    public String message(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        return this.message(pageContext, bundle, locale, key, null);
    }

    public String message(PageContext pageContext, String bundle, String locale, String key, Object[] args) throws JspException {
        MessageResources resources = this.retrieveMessageResources(pageContext, bundle, false);
        Locale userLocale = this.getUserLocale(pageContext, locale);
        String message = null;
        message = args == null ? resources.getMessage(userLocale, key) : resources.getMessage(userLocale, key, args);
        if (message == null && log.isDebugEnabled()) {
            log.debug(resources.getMessage("message.resources", (Object)key, (Object)bundle, (Object)locale));
        }
        return message;
    }

    public String pageURL(HttpServletRequest request, String page, ModuleConfig moduleConfig) {
        StringBuffer sb = new StringBuffer();
        String pagePattern = moduleConfig.getControllerConfig().getPagePattern();
        if (pagePattern == null) {
            sb.append(moduleConfig.getPrefix());
            sb.append(page);
        } else {
            boolean dollar = false;
            for (int i = 0; i < pagePattern.length(); ++i) {
                char ch = pagePattern.charAt(i);
                if (dollar) {
                    switch (ch) {
                        case 'M': {
                            sb.append(moduleConfig.getPrefix());
                            break;
                        }
                        case 'P': {
                            sb.append(page);
                            break;
                        }
                        case '$': {
                            sb.append('$');
                            break;
                        }
                    }
                    dollar = false;
                    continue;
                }
                if (ch == '$') {
                    dollar = true;
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    public boolean present(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        MessageResources resources = this.retrieveMessageResources(pageContext, bundle, true);
        Locale userLocale = this.getUserLocale(pageContext, locale);
        return resources.isPresent(userLocale, key);
    }

    public MessageResources retrieveMessageResources(PageContext pageContext, String bundle, boolean checkPageScope) throws JspException {
        MessageResources resources = null;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
        }
        if (checkPageScope) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 1);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 2);
        }
        if (resources == null) {
            ModuleConfig moduleConfig = this.getModuleConfig(pageContext);
            resources = (MessageResources)pageContext.getAttribute(bundle + moduleConfig.getPrefix(), 4);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 4);
        }
        if (resources == null) {
            JspException e = new JspException(messages.getMessage("message.bundle", (Object)bundle));
            this.saveException(pageContext, e);
            throw e;
        }
        return resources;
    }

    public void saveException(PageContext pageContext, Throwable exception) {
        pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)exception, 2);
    }

    public void write(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        try {
            writer.print(text);
        }
        catch (IOException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("write.io", (Object)e.toString()));
        }
    }

    public void writePrevious(PageContext pageContext, String text) throws JspException {
        JspWriter writer = pageContext.getOut();
        if (writer instanceof BodyContent) {
            writer = ((BodyContent)writer).getEnclosingWriter();
        }
        try {
            writer.print(text);
        }
        catch (IOException e) {
            this.saveException(pageContext, e);
            throw new JspException(messages.getMessage("write.io", (Object)e.toString()));
        }
    }

    static {
        scopes.put("page", new Integer(1));
        scopes.put("request", new Integer(2));
        scopes.put("session", new Integer(3));
        scopes.put("application", new Integer(4));
    }
}

