/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.SecurePlugInInterface;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.SecureActionConfig;
import org.apache.struts.taglib.TagUtils;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.ModuleUtils;

public class SecureRequestUtils {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.html.LocalStrings");
    private static Log sLog = LogFactory.getLog(class$org$apache$struts$util$SecureRequestUtils == null ? (class$org$apache$struts$util$SecureRequestUtils = SecureRequestUtils.class$("org.apache.struts.util.SecureRequestUtils")) : class$org$apache$struts$util$SecureRequestUtils);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String STD_HTTP_PORT = "80";
    private static final String STD_HTTPS_PORT = "443";
    private static final String STOWED_REQUEST_ATTRIBS = "ssl.redirect.attrib.stowed";
    static /* synthetic */ Class class$org$apache$struts$util$SecureRequestUtils;

    public static String computeURL(PageContext pageContext, String forward, String href, String page, String action, String module, Map params, String anchor, boolean redirect) throws MalformedURLException {
        StringBuffer url = new StringBuffer(TagUtils.getInstance().computeURL(pageContext, forward, href, page, action, module, params, anchor, redirect));
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        ServletContext servletContext = pageContext.getServletContext();
        String contextPath = request.getContextPath();
        SecurePlugInInterface securePlugin = (SecurePlugInInterface)servletContext.getAttribute("org.apache.struts.action.SecurePlugIn-Instance");
        if (securePlugin.getSslExtEnable() && url.toString().startsWith(contextPath)) {
            String usingScheme = request.getScheme();
            String usingPort = String.valueOf(request.getServerPort());
            String linkString = url.toString().substring(contextPath.length());
            SecureActionConfig secureConfig = SecureRequestUtils.getActionConfig(pageContext, linkString);
            if (secureConfig != null && !"any".equalsIgnoreCase(secureConfig.getSecure())) {
                String desiredPort;
                String desiredScheme = Boolean.valueOf(secureConfig.getSecure()) != false ? HTTPS : HTTP;
                String string = desiredPort = Boolean.valueOf(secureConfig.getSecure()) != false ? securePlugin.getHttpsPort() : securePlugin.getHttpPort();
                if (!desiredScheme.equals(usingScheme) || !desiredPort.equals(usingPort)) {
                    url.insert(0, (Object)SecureRequestUtils.startNewUrlString(request, desiredScheme, desiredPort));
                    if (securePlugin.getSslExtAddSession() && url.toString().indexOf(";jsessionid=") < 0) {
                        url = new StringBuffer(SecureRequestUtils.toEncoded(url.toString(), request.getSession().getId()));
                    }
                }
            }
        }
        return url.toString();
    }

    private static SecureActionConfig getActionConfig(PageContext pageContext, String linkString) {
        ModuleConfig moduleConfig = SecureRequestUtils.selectModule(linkString, pageContext);
        linkString = linkString.substring(moduleConfig.getPrefix().length());
        ServletContext servletContext = pageContext.getServletContext();
        SecurePlugInInterface spi = (SecurePlugInInterface)servletContext.getAttribute("org.apache.struts.action.SecurePlugIn-Instance");
        Iterator mappingItr = spi.getServletMappings().iterator();
        while (mappingItr.hasNext()) {
            int question;
            int anchor;
            int starIndex;
            String servletMapping = (String)mappingItr.next();
            int n = starIndex = servletMapping != null ? servletMapping.indexOf(42) : -1;
            if (starIndex == -1) continue;
            String prefix = servletMapping.substring(0, starIndex);
            String suffix = servletMapping.substring(starIndex + 1);
            int jsession = linkString.indexOf(";jsessionid=");
            if (jsession >= 0) {
                linkString = linkString.substring(0, jsession);
            }
            if ((anchor = linkString.indexOf("#")) >= 0) {
                linkString = linkString.substring(0, anchor);
            }
            if ((question = linkString.indexOf("?")) >= 0) {
                linkString = linkString.substring(0, question);
            }
            if (!linkString.startsWith(prefix) || !linkString.endsWith(suffix)) continue;
            linkString = linkString.substring(prefix.length());
            if (!(linkString = linkString.substring(0, linkString.length() - suffix.length())).startsWith("/")) {
                linkString = "/" + linkString;
            }
            SecureActionConfig secureConfig = (SecureActionConfig)moduleConfig.findActionConfig(linkString);
            return secureConfig;
        }
        return null;
    }

    private static StringBuffer startNewUrlString(HttpServletRequest request, String desiredScheme, String desiredPort) {
        StringBuffer url = new StringBuffer();
        String serverName = request.getServerName();
        url.append(desiredScheme).append("://").append(serverName);
        if (HTTP.equals(desiredScheme) && !STD_HTTP_PORT.equals(desiredPort) || HTTPS.equals(desiredScheme) && !STD_HTTPS_PORT.equals(desiredPort)) {
            url.append(":").append(desiredPort);
        }
        return url;
    }

    public static String getRequestParameters(HttpServletRequest aRequest) {
        Map m4 = SecureRequestUtils.getParameterMap(aRequest);
        return SecureRequestUtils.createQueryStringFromMap(m4, "&").toString();
    }

    public static StringBuffer createQueryStringFromMap(Map m4, String ampersand) {
        StringBuffer aReturn = new StringBuffer("");
        Set aEntryS = m4.entrySet();
        Iterator aEntryI = aEntryS.iterator();
        while (aEntryI.hasNext()) {
            Map.Entry aEntry = aEntryI.next();
            Object value = aEntry.getValue();
            String[] aValues = new String[1];
            if (value == null) {
                aValues[0] = "";
            } else if (value instanceof List) {
                List aList = (List)value;
                aValues = aList.toArray(new String[aList.size()]);
            } else if (value instanceof String) {
                aValues[0] = (String)value;
            } else {
                aValues = (String[])value;
            }
            int i = 0;
            while (i < aValues.length) {
                SecureRequestUtils.append(aEntry.getKey(), aValues[i], aReturn, ampersand);
                ++i;
            }
        }
        return aReturn;
    }

    private static StringBuffer append(Object key, Object value, StringBuffer queryString, String ampersand) {
        if (queryString.length() > 0) {
            queryString.append(ampersand);
        }
        TagUtils tagUtils = TagUtils.getInstance();
        queryString.append(tagUtils.encodeURL(key.toString()));
        queryString.append("=");
        queryString.append(tagUtils.encodeURL(value.toString()));
        return queryString;
    }

    public static boolean stowRequestAttributes(HttpServletRequest aRequest) {
        if (aRequest.getSession().getAttribute(STOWED_REQUEST_ATTRIBS) != null) {
            return false;
        }
        Enumeration enumeration = aRequest.getAttributeNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            map.put(name, aRequest.getAttribute(name));
        }
        aRequest.getSession().setAttribute(STOWED_REQUEST_ATTRIBS, map);
        return true;
    }

    public static void reclaimRequestAttributes(HttpServletRequest aRequest, boolean doRemove) {
        Map map = (Map)aRequest.getSession().getAttribute(STOWED_REQUEST_ATTRIBS);
        if (map == null) {
            return;
        }
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            aRequest.setAttribute(name, map.get(name));
        }
        if (doRemove) {
            aRequest.getSession().removeAttribute(STOWED_REQUEST_ATTRIBS);
        }
    }

    public static String getRedirectString(HttpServletRequest request, ServletContext application, String isSecure) {
        String urlString = null;
        SecurePlugInInterface securePlugin = (SecurePlugInInterface)application.getAttribute("org.apache.struts.action.SecurePlugIn-Instance");
        String httpPort = securePlugin.getHttpPort();
        String httpsPort = securePlugin.getHttpsPort();
        if (!securePlugin.getSslExtEnable() || "any".equalsIgnoreCase(isSecure)) {
            return urlString;
        }
        String desiredScheme = Boolean.valueOf(isSecure) != false ? HTTPS : HTTP;
        String usingScheme = request.getScheme();
        String desiredPort = Boolean.valueOf(isSecure) != false ? httpsPort : httpPort;
        String usingPort = String.valueOf(request.getServerPort());
        if (!desiredScheme.equals(usingScheme) || !desiredPort.equals(usingPort)) {
            urlString = SecureRequestUtils.buildNewUrlString(request, desiredScheme, desiredPort, securePlugin.getSslExtAddSession());
            if (!SecureRequestUtils.stowRequestAttributes(request)) {
                SecureRequestUtils.reclaimRequestAttributes(request, false);
            }
        } else {
            SecureRequestUtils.reclaimRequestAttributes(request, true);
        }
        return urlString;
    }

    private static String buildNewUrlString(HttpServletRequest request, String desiredScheme, String desiredPort, boolean addSessionID) {
        StringBuffer url = SecureRequestUtils.startNewUrlString(request, desiredScheme, desiredPort);
        url.append(request.getRequestURI());
        String returnUrl = SecureRequestUtils.addQueryString(request, url);
        if (addSessionID) {
            returnUrl = SecureRequestUtils.toEncoded(returnUrl, request.getSession().getId());
        }
        return returnUrl;
    }

    private static String addQueryString(HttpServletRequest request, StringBuffer url) {
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() != 0) {
            url.append("?" + queryString);
        } else {
            queryString = SecureRequestUtils.getRequestParameters(request);
            if (queryString != null && queryString.length() != 0) {
                url.append("?" + queryString);
            }
        }
        return url.toString();
    }

    public static ModuleConfig selectModule(String urlPath, PageContext pageContext) {
        ServletContext servletContext = pageContext.getServletContext();
        String prefix = ModuleUtils.getInstance().getModuleName(urlPath, servletContext);
        ModuleConfig config = ModuleUtils.getInstance().getModuleConfig(prefix, servletContext);
        return config;
    }

    private static Map getParameterMap(HttpServletRequest request) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] values = request.getParameterValues(name);
            map.put(name, values);
        }
        return map;
    }

    public static boolean checkSsl(SecureActionConfig aMapping, ServletContext aContext, HttpServletRequest aRequest, HttpServletResponse aResponse) {
        String redirectString = SecureRequestUtils.getRedirectString(aRequest, aContext, aMapping.getSecure());
        if (redirectString != null) {
            try {
                aResponse.sendRedirect(aResponse.encodeRedirectURL(redirectString));
                return true;
            }
            catch (Exception ioe) {
                sLog.error("IOException in redirect" + ioe.getMessage());
            }
        }
        return false;
    }

    private static String toEncoded(String url, String sessionId) {
        StringBuffer sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

