/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IdentityHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();
    private static final long serialVersionUID = 362498820763181265L;

    public IdentityHashMap() {
        this(11, 0.75f);
    }

    public IdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IdentityHashMap(Map t2) {
        this(Math.max(2 * t2.size(), 11), 0.75f);
        this.putAll(t2);
    }

    int capacity() {
        return this.table.length;
    }

    public void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            IdentityHashMap t2 = (IdentityHashMap)super.clone();
            t2.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                Entry entry = t2.table[i] = this.table[i] != null ? (Entry)this.table[i].clone() : null;
            }
            t2.keySet = null;
            t2.entrySet = null;
            t2.values = null;
            t2.modCount = 0;
            return t2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean containsKey(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = System.identityHashCode(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && key == e.key) {
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            while (e != null) {
                if (e.key == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Entry[] tab = this.table;
        if (value == null) {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = IdentityHashMap.this.table;
                    int hash = key == null ? 0 : System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    while (e != null) {
                        if (e.hash == hash && e.equals(entry)) {
                            return true;
                        }
                        e = e.next;
                    }
                    return false;
                }

                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(2);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = IdentityHashMap.this.table;
                    int hash = key == null ? 0 : System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        if (e.hash == hash && e.equals(entry)) {
                            IdentityHashMap identityHashMap = IdentityHashMap.this;
                            identityHashMap.modCount = identityHashMap.modCount + 1;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            IdentityHashMap identityHashMap2 = IdentityHashMap.this;
                            identityHashMap2.count = identityHashMap2.count - 1;
                            e.value = null;
                            return true;
                        }
                        prev = e;
                        e = e.next;
                    }
                    return false;
                }

                public int size() {
                    return IdentityHashMap.this.count;
                }
            };
        }
        return this.entrySet;
    }

    public Object get(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = System.identityHashCode(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && key == e.key) {
                    return e.value;
                }
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            while (e != null) {
                if (e.key == null) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return null;
    }

    private Iterator getHashIterator(int type) {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator(type);
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean contains(Object o) {
                    return IdentityHashMap.this.containsKey(o);
                }

                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(0);
                }

                public boolean remove(Object o) {
                    int oldSize = IdentityHashMap.this.count;
                    IdentityHashMap.this.remove(o);
                    return IdentityHashMap.this.count != oldSize;
                }

                public int size() {
                    return IdentityHashMap.this.count;
                }
            };
        }
        return this.keySet;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public Object put(Object key, Object value) {
        Entry e;
        Entry[] tab = this.table;
        int hash = 0;
        int index = 0;
        if (key != null) {
            hash = System.identityHashCode(key);
            index = (hash & Integer.MAX_VALUE) % tab.length;
            e = tab[index];
            while (e != null) {
                if (e.hash == hash && key == e.key) {
                    Object old = e.value;
                    e.value = value;
                    return old;
                }
                e = e.next;
            }
        } else {
            e = tab[0];
            while (e != null) {
                if (e.key == null) {
                    Object old = e.value;
                    e.value = value;
                    return old;
                }
                e = e.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public void putAll(Map t2) {
        Iterator i = t2.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int numBuckets = s2.readInt();
        this.table = new Entry[numBuckets];
        int size = s2.readInt();
        int i = 0;
        while (i < size) {
            Object key = s2.readObject();
            Object value = s2.readObject();
            this.put(key, value);
            ++i;
        }
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object remove(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = System.identityHashCode(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e.hash == hash && key == e.key) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                    Object oldValue = e.value;
                    e.value = null;
                    return oldValue;
                }
                prev = e;
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                if (e.key == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                    Object oldValue = e.value;
                    e.value = null;
                    return oldValue;
                }
                prev = e;
                e = e.next;
            }
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public void clear() {
                    IdentityHashMap.this.clear();
                }

                public boolean contains(Object o) {
                    return IdentityHashMap.this.containsValue(o);
                }

                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(1);
                }

                public int size() {
                    return IdentityHashMap.this.count;
                }
            };
        }
        return this.values;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.table.length);
        s2.writeInt(this.count);
        int index = this.table.length - 1;
        while (index >= 0) {
            Entry entry = this.table[index];
            while (entry != null) {
                s2.writeObject(entry.key);
                s2.writeObject(entry.value);
                entry = entry.next;
            }
            --index;
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null) {
                if (e.getKey() != null) {
                    return false;
                }
            } else {
                boolean bl = this.key.equals(e.getKey());
                if (!bl) return false;
            }
            if (this.value == null) {
                if (e.getValue() == null) return true;
                return false;
            }
            boolean bl = this.value.equals(e.getValue());
            if (bl) return true;
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.key)) + "=" + this.value;
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private class HashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int type) {
            this.table = IdentityHashMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.type = type;
        }

        public boolean hasNext() {
            Entry e = this.entry;
            int i = this.index;
            Entry[] t2 = this.table;
            while (e == null && i > 0) {
                e = t2[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        public Object next() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.entry;
            int i = this.index;
            Entry[] t2 = this.table;
            while (et == null && i > 0) {
                et = t2[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                Entry e = this.lastReturned = this.entry;
                this.entry = e.next;
                return this.type == 0 ? e.key : (this.type == 1 ? e.value : e);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = IdentityHashMap.this.table;
            int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturned) {
                    IdentityHashMap identityHashMap = IdentityHashMap.this;
                    identityHashMap.modCount = identityHashMap.modCount + 1;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    IdentityHashMap identityHashMap2 = IdentityHashMap.this;
                    identityHashMap2.count = identityHashMap2.count - 1;
                    this.lastReturned = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }
}

