/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.EndOfSmlMessage;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;
import org.openmuc.jsml.structures.SmlMessageBody;
import org.openmuc.jsml.structures.Unsigned16;
import org.openmuc.jsml.structures.Unsigned8;
import org.openmuc.jsml.transport.Crc16;

public class SmlMessage
extends Sequence {
    private OctetString transactionId;
    private Unsigned8 groupNo;
    private Unsigned8 abortOnError;
    private SmlMessageBody messageBody;
    private Unsigned16 crc16;
    private EndOfSmlMessage endOfSmlMsg;

    public SmlMessage() {
    }

    public SmlMessage(OctetString transactionId, Unsigned8 groupNo, Unsigned8 abortOnError, SmlMessageBody messageBody) {
        this.transactionId = transactionId;
        this.groupNo = groupNo;
        this.abortOnError = abortOnError;
        this.messageBody = messageBody;
        this.crc16 = new Unsigned16();
        this.endOfSmlMsg = new EndOfSmlMessage();
        this.seqArray(transactionId, groupNo, abortOnError, messageBody, this.crc16, this.endOfSmlMsg);
        this.setSelected(true);
    }

    public void setTransactionId(OctetString transactionId) {
        this.transactionId = transactionId;
    }

    public void setGroupNo(Unsigned8 groupNo) {
        this.groupNo = groupNo;
    }

    public void setAbortOnError(Unsigned8 abortOnError) {
        this.abortOnError = abortOnError;
    }

    public OctetString getTransactionId() {
        return this.transactionId;
    }

    public Unsigned8 getGroupNo() {
        return this.groupNo;
    }

    public Unsigned8 getAbortOnError() {
        return this.abortOnError;
    }

    public SmlMessageBody getMessageBody() {
        return this.messageBody;
    }

    @Override
    public void encode(DataOutputStream os) throws IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(50);
        DataOutputStream os2 = new DataOutputStream(bs);
        super.encode(os2);
        byte[] bytes = bs.toByteArray();
        int crc = Crc16.check(bytes, bytes.length - 4);
        this.crc16 = new Unsigned16(crc);
        bytes[bytes.length - 3] = (byte)((crc & 0xFF00) >> 8);
        bytes[bytes.length - 2] = (byte)(crc & 0xFF);
        os.write(bytes);
    }

    public boolean decodeAndCheck(DataInputStream is) throws IOException {
        int size = is.available();
        is.mark(size + 1);
        if (super.decode(is)) {
            int crcmessage;
            int rest = is.available();
            int crc = this.crc16.getVal();
            int messageEndingSize = 4;
            if (crc <= 255) {
                messageEndingSize = 3;
            }
            int len = size - rest - messageEndingSize;
            byte[] message = new byte[len];
            is.reset();
            is.readFully(message);
            long skipLength = is.skip(messageEndingSize);
            if ((long)messageEndingSize != skipLength) {
                // empty if block
            }
            if (crc != (crcmessage = Crc16.check(message))) {
                return messageEndingSize == 3 && crc == Crc16.check(message, message.length - 1);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void createElements() {
        this.transactionId = new OctetString();
        this.groupNo = new Unsigned8();
        this.abortOnError = new Unsigned8();
        this.messageBody = new SmlMessageBody();
        this.crc16 = new Unsigned16();
        this.endOfSmlMsg = new EndOfSmlMessage();
        this.seqArray(this.transactionId, this.groupNo, this.abortOnError, this.messageBody, this.crc16, this.endOfSmlMsg);
    }
}

