/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import java.util.Collection;
import java.util.HashSet;
import org.parboiled.common.Formatter;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.trees.GraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphUtils {
    private GraphUtils() {
    }

    public static boolean hasChildren(GraphNode<?> graphNode) {
        return graphNode != null && !graphNode.getChildren().isEmpty();
    }

    public static <T extends GraphNode<T>> T getFirstChild(T t2) {
        return (T)(GraphUtils.hasChildren(t2) ? (GraphNode)t2.getChildren().get(0) : null);
    }

    public static <T extends GraphNode<T>> T getLastChild(T t2) {
        return (T)(GraphUtils.hasChildren(t2) ? (GraphNode)t2.getChildren().get(t2.getChildren().size() - 1) : null);
    }

    public static <T extends GraphNode<T>> int countAllDistinct(T t2) {
        if (t2 == null) {
            return 0;
        }
        return GraphUtils.collectAllNodes(t2, new HashSet()).size();
    }

    public static <T extends GraphNode<T>, C extends Collection<T>> C collectAllNodes(T t2, C c) {
        Preconditions.checkArgNotNull(c, "collection");
        if (t2 != null && !c.contains(t2)) {
            c.add(t2);
            for (GraphNode graphNode : t2.getChildren()) {
                GraphUtils.collectAllNodes(graphNode, c);
            }
        }
        return c;
    }

    public static <T extends GraphNode<T>> String printTree(T t2, Formatter<T> formatter) {
        Preconditions.checkArgNotNull(formatter, "formatter");
        return GraphUtils.printTree(t2, formatter, Predicates.alwaysTrue(), Predicates.alwaysTrue());
    }

    public static <T extends GraphNode<T>> String printTree(T t2, Formatter<T> formatter, Predicate<T> predicate, Predicate<T> predicate2) {
        Preconditions.checkArgNotNull(formatter, "formatter");
        Preconditions.checkArgNotNull(predicate, "nodeFilter");
        Preconditions.checkArgNotNull(predicate2, "subTreeFilter");
        return t2 == null ? "" : GraphUtils.printTree(t2, formatter, "", new StringBuilder(), predicate, predicate2).toString();
    }

    private static <T extends GraphNode<T>> StringBuilder printTree(T t2, Formatter<T> formatter, String string, StringBuilder stringBuilder, Predicate<T> predicate, Predicate<T> predicate2) {
        Object object;
        if (predicate.apply(t2) && (object = formatter.format(t2)) != null) {
            stringBuilder.append(string).append((String)object).append("\n");
            string = string + "  ";
        }
        if (predicate2.apply(t2)) {
            for (GraphNode graphNode : t2.getChildren()) {
                GraphUtils.printTree(graphNode, formatter, string, stringBuilder, predicate, predicate2);
            }
        }
        return stringBuilder;
    }
}

